/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.radio.radio;

import com.mojang.authlib.GameProfile;
import de.maxhenkel.radio.Radio;
import de.maxhenkel.radio.radio.RadioData;
import de.maxhenkel.radio.radio.RadioStream;
import de.maxhenkel.radio.utils.IPossibleRadioBlock;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2631;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_4076;
import net.minecraft.class_9296;

public class RadioManager {
    private final Map<UUID, RadioStream> radioStreams = new HashMap<UUID, RadioStream>();
    private static RadioManager instance;

    @Deprecated(since="2.0")
    public Optional<RadioData> loadHeadFromGameProfile(class_2631 skullBlockEntity) {
        class_1937 class_19372 = skullBlockEntity.method_10997();
        if (!(class_19372 instanceof class_3218)) {
            return Optional.empty();
        }
        class_3218 serverLevel = (class_3218)class_19372;
        class_9296 resolvableProfile = skullBlockEntity.method_11334();
        if (resolvableProfile == null) {
            return Optional.empty();
        }
        try {
            GameProfile ownerProfile = resolvableProfile.method_73313();
            RadioData radioData = RadioData.fromGameProfile(ownerProfile);
            if (radioData == null) {
                return Optional.empty();
            }
            return Optional.of(radioData);
        }
        catch (Exception err) {
            Radio.LOGGER.error("Loading legacy format radio data failed", (Throwable)err);
            return Optional.empty();
        }
    }

    public boolean updateRadioStream(RadioData radioData, class_3218 serverLevel, class_2586 skullBlockEntity) {
        boolean idChanged = radioData.assignIdIfNil();
        RadioStream radioStream = new RadioStream(radioData, serverLevel, skullBlockEntity.method_11016());
        Radio.LOGGER.debug("Loaded radio stream for '{}' ({})", (Object)radioData.getStationName(), (Object)radioData.getId());
        radioStream.init();
        RadioStream oldStream = this.radioStreams.put(radioData.getId(), radioStream);
        if (oldStream != null) {
            oldStream.close();
            Radio.LOGGER.warn("Replacing radio stream for '{}' ({})  - Old stream state was '{}'", (Object)radioData.getStationName(), (Object)radioData.getId(), (Object)oldStream.getState());
        }
        return idChanged;
    }

    public Optional<RadioStream> getRadioStream(UUID id) {
        return Optional.ofNullable(this.radioStreams.get(id));
    }

    public Optional<RadioStream> getRadioStream(RadioData radio) {
        return this.getRadioStream(radio.getId());
    }

    public static boolean isValidRadioLocation(UUID id, class_2338 pos, class_3218 level) {
        if (!level.method_8477(pos)) {
            return false;
        }
        class_2586 blockEntity = level.method_8321(pos);
        if (!(blockEntity instanceof IPossibleRadioBlock)) {
            return false;
        }
        IPossibleRadioBlock radioBlock = (IPossibleRadioBlock)blockEntity;
        return radioBlock.radio$isRadio() && radioBlock.radio$getRadioData().getId().equals(id);
    }

    public void onRemoveHead(UUID id) {
        RadioStream radioStream = this.radioStreams.remove(id);
        if (radioStream != null) {
            radioStream.close();
            Radio.LOGGER.debug("Removed radio stream for '{}' ({})", (Object)radioStream.getRadioData().getStationName(), (Object)radioStream.getRadioData().getId());
        } else {
            Radio.LOGGER.debug("Removed radio stream {}", (Object)id);
        }
    }

    public void stopStream(UUID id) {
        RadioStream radioStream = this.radioStreams.get(id);
        if (radioStream != null) {
            radioStream.stop();
        }
    }

    public void updateHeadOnState(UUID id, boolean on) {
        RadioStream radioStream = this.radioStreams.get(id);
        if (radioStream == null) {
            Radio.LOGGER.info("No stream detected.");
            return;
        }
        if (on) {
            radioStream.start();
        } else {
            radioStream.stop();
        }
    }

    public void onChunkUnload(class_3218 serverLevel, class_2818 levelChunk) {
        this.radioStreams.values().removeIf(radioStream -> {
            boolean remove;
            boolean bl = remove = radioStream.getServerLevel().method_27983().equals(serverLevel.method_27983()) && RadioManager.isInChunk(radioStream.getPosition(), levelChunk.method_12004());
            if (remove) {
                radioStream.close();
            }
            return remove;
        });
    }

    private static boolean isInChunk(class_2338 pos, class_1923 chunkPos) {
        int chunkX = class_4076.method_18675((int)pos.method_10263());
        int chunkZ = class_4076.method_18675((int)pos.method_10260());
        return chunkX == chunkPos.field_9181 && chunkZ == chunkPos.field_9180;
    }

    public void clear() {
        this.radioStreams.values().forEach(RadioStream::close);
        this.radioStreams.clear();
    }

    public static RadioManager getInstance() {
        if (instance == null) {
            instance = new RadioManager();
        }
        return instance;
    }
}

