/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.radio.radio;

import de.maxhenkel.radio.Radio;
import de.maxhenkel.radio.RadioVoicechatPlugin;
import de.maxhenkel.radio.javazoom.jl.decoder.Bitstream;
import de.maxhenkel.radio.javazoom.jl.decoder.Decoder;
import de.maxhenkel.radio.javazoom.jl.decoder.Header;
import de.maxhenkel.radio.javazoom.jl.decoder.SampleBuffer;
import de.maxhenkel.radio.radio.RadioData;
import de.maxhenkel.radio.radio.RadioManager;
import de.maxhenkel.radio.radio.StreamConverter;
import de.maxhenkel.radio.utils.RadioStreamState;
import de.maxhenkel.voicechat.api.Position;
import de.maxhenkel.voicechat.api.ServerLevel;
import de.maxhenkel.voicechat.api.VoicechatServerApi;
import de.maxhenkel.voicechat.api.audiochannel.AudioChannel;
import de.maxhenkel.voicechat.api.audiochannel.AudioPlayer;
import de.maxhenkel.voicechat.api.audiochannel.LocationalAudioChannel;
import de.maxhenkel.voicechat.api.opus.OpusEncoderMode;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_156;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;

public class RadioStream
implements Supplier<short[]> {
    private final RadioData radioData;
    private final UUID id;
    private final class_3218 serverLevel;
    private final class_2338 position;
    private UUID lastKnownChannelId;
    private RadioStreamState state;
    @Nullable
    private LocationalAudioChannel channel;
    @Nullable
    private AudioPlayer audioPlayer;
    @Nullable
    private Bitstream bitstream;
    @Nullable
    private Decoder decoder;
    @Nullable
    private StreamConverter streamConverter;
    private int lastSampleCount;
    private long lastParticle = 0L;
    private long lastCheck;

    public RadioStream(RadioData radioData, class_3218 serverLevel, class_2338 position) {
        this.radioData = radioData;
        this.id = radioData.getId();
        this.serverLevel = serverLevel;
        this.position = position;
        this.lastKnownChannelId = class_156.field_25140;
        this.state = RadioStreamState.FRESH;
    }

    public void init() {
        if (!this.radioData.isOn()) {
            return;
        }
        if (this.state.canBeStarted()) {
            this.start();
        } else {
            Radio.LOGGER.warn("Tried to start pre-used radio station in state [{}]", (Object)this.state);
        }
    }

    public void start() {
        Throwable trace = new Throwable();
        RadioVoicechatPlugin.runWhenReady(() -> {
            try {
                if (!this.preStartInternal(trace)) {
                    this.state = RadioStreamState.ERRORED_PRE_INIT;
                    return;
                }
            }
            catch (IOException | URISyntaxException e) {
                this.state = RadioStreamState.ERRORED_PRE_INIT;
                Radio.LOGGER.error("Failed to setup radio stream", (Throwable)e);
                return;
            }
            new Thread(() -> {
                try {
                    this.state = this.startInternal(trace) ? RadioStreamState.ACTIVE : RadioStreamState.ERRORED;
                }
                catch (IOException | URISyntaxException e) {
                    this.state = RadioStreamState.ERRORED;
                    Radio.LOGGER.error("Failed to start radio stream", (Throwable)e);
                }
            }, "RadioStreamStarter-%s".formatted(this.id)).start();
        });
    }

    private boolean preStartInternal(Throwable trace) throws IOException, URISyntaxException {
        if (this.radioData.getUrl() == null) {
            Radio.LOGGER.warn("Radio URL is null");
            return false;
        }
        VoicechatServerApi api = RadioVoicechatPlugin.voicechatServerApi;
        if (api == null) {
            Radio.LOGGER.error("Voice chat API is not yet loaded");
            return false;
        }
        if (this.channel != null) {
            Radio.LOGGER.warn("Voice channel exists already. Ignoring.");
            return false;
        }
        if (this.serverLevel == null) {
            Radio.LOGGER.error("Server level is null while trying to create radio channel");
            return false;
        }
        ServerLevel level = api.fromServerLevel((Object)this.serverLevel);
        Position pos = api.createPosition((double)this.position.method_10263() + 0.5, (double)this.position.method_10264() + 0.5, (double)this.position.method_10260() + 0.5);
        this.lastKnownChannelId = UUID.randomUUID();
        this.channel = api.createLocationalAudioChannel(this.lastKnownChannelId, level, pos);
        if (this.channel == null) {
            Radio.LOGGER.error("Failed to create locational audio channel.", trace);
            return false;
        }
        this.channel.setDistance(this.getOutputChannelRange());
        this.channel.setCategory(RadioVoicechatPlugin.RADIOS_CATEGORY);
        this.audioPlayer = api.createAudioPlayer((AudioChannel)this.channel, api.createEncoder(OpusEncoderMode.AUDIO), (Supplier)this);
        if (this.audioPlayer == null) {
            Radio.LOGGER.error("Could not initialise radio stream player -- audio player is null.", trace);
            return false;
        }
        return true;
    }

    private boolean startInternal(Throwable trace) throws IOException, URISyntaxException {
        if (this.audioPlayer == null) {
            Radio.LOGGER.debug("Unable to start radio stream player -- was the player halted too quickly?", trace);
            return false;
        }
        InputStream input = new URI(this.radioData.getUrl()).toURL().openStream();
        this.bitstream = new Bitstream(new BufferedInputStream(input));
        this.decoder = new Decoder();
        this.audioPlayer.startPlaying();
        this.state = RadioStreamState.ACTIVE;
        return true;
    }

    public void stop() {
        Radio.LOGGER.debug("Stopping radio stream for '{}' ({})", (Object)this.radioData.getStationName(), (Object)this.radioData.getId());
        this.channel = null;
        if (this.audioPlayer != null) {
            this.audioPlayer.stopPlaying();
            this.audioPlayer = null;
        }
        if (this.bitstream != null) {
            try {
                this.bitstream.close();
            }
            catch (Exception e) {
                Radio.LOGGER.warn("Failed to close bitstream", (Throwable)e);
            }
            this.bitstream = null;
        }
        this.decoder = null;
        this.streamConverter = null;
        if (this.state.isActive()) {
            this.state = RadioStreamState.STOPPED;
        }
        Radio.LOGGER.debug("Stopped radio stream for '{}' ({})", (Object)this.radioData.getStationName(), (Object)this.radioData.getId());
    }

    public class_2338 getPosition() {
        return this.position;
    }

    public class_3218 getServerLevel() {
        return this.serverLevel;
    }

    public RadioData getRadioData() {
        return this.radioData;
    }

    @Override
    public short[] get() {
        if (this.channel == null) {
            return null;
        }
        if (this.bitstream == null || this.decoder == null) {
            throw new IllegalStateException("Radio stream not started");
        }
        this.checkValid();
        this.spawnParticle();
        try {
            if (this.streamConverter != null && !this.streamConverter.canAdd(this.lastSampleCount)) {
                return this.streamConverter.getFrame();
            }
            Header frameHeader = this.bitstream.readFrame();
            if (frameHeader == null) {
                this.state = RadioStreamState.ERRORED_NO_CLEANUP;
                throw new IOException("End of stream");
            }
            SampleBuffer output = (SampleBuffer)this.decoder.decodeFrame(frameHeader, this.bitstream);
            short[] samples = output.getBuffer();
            this.lastSampleCount = output.getBufferLength();
            this.bitstream.closeFrame();
            if (this.streamConverter == null) {
                this.streamConverter = new StreamConverter(this.decoder.getOutputFrequency(), this.decoder.getOutputChannels());
            }
            this.streamConverter.add(samples, 0, output.getBufferLength());
            return this.streamConverter.getFrame();
        }
        catch (Exception e) {
            Radio.LOGGER.warn("Failed to stream audio from {}", (Object)this.radioData.getUrl(), (Object)e);
            this.stop();
            this.state = RadioStreamState.ERRORED;
            return null;
        }
    }

    public void spawnParticle() {
        if (!Radio.SERVER_CONFIG.showMusicParticles.get().booleanValue()) {
            return;
        }
        long time = System.currentTimeMillis();
        if (time - this.lastParticle < Radio.SERVER_CONFIG.musicParticleFrequency.get()) {
            return;
        }
        this.lastParticle = time;
        this.serverLevel.method_8503().execute(() -> {
            class_243 vec3 = class_243.method_24955((class_2382)this.position).method_1031(0.0, 1.0, 0.0);
            this.serverLevel.method_18456().stream().filter(player -> player.method_73189().method_1022(this.position.method_46558()) <= 32.0).forEach(player -> {
                float random = (float)this.serverLevel.method_8409().method_43048(4) / 24.0f;
                this.serverLevel.method_65096((class_2394)class_2398.field_11224, vec3.method_10216(), vec3.method_10214(), vec3.method_10215(), 0, (double)random, 0.0, 0.0, 1.0);
            });
        });
    }

    private void checkValid() {
        long time = System.currentTimeMillis();
        if (time - this.lastCheck < 30000L) {
            return;
        }
        this.lastCheck = time;
        this.serverLevel.method_8503().execute(() -> {
            if (!RadioManager.isValidRadioLocation(this.id, this.position, this.serverLevel)) {
                RadioManager.getInstance().stopStream(this.id);
                Radio.LOGGER.warn("Stopped radio stream {} as it doesn't exist anymore", (Object)this.id);
            }
        });
    }

    public void close() {
        this.stop();
    }

    public float getOutputChannelRange() {
        float range = this.radioData.getRange();
        return range > 0.0f ? range : Radio.SERVER_CONFIG.radioRange.get().floatValue();
    }

    public UUID getLastKnownChannelId() {
        return this.lastKnownChannelId;
    }

    public RadioStreamState getState() {
        return this.state;
    }
}

