/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.radio.radio;

import de.maxhenkel.radio.Radio;
import de.maxhenkel.radio.utils.CircularShortBuffer;

public class StreamConverter {
    public static final int FRAME_SIZE_SAMPLES = 960;
    private static final int TARGET_SAMPLE_RATE = 48000;
    private final int inputSampleRate;
    private final int inputChannels;
    private final double resampleFactor;
    private final int sourceSamplesNeeded;
    private final CircularShortBuffer buffer;

    public StreamConverter(int inputSampleRate, int inputChannels) {
        if (inputChannels < 1 || inputChannels > 2) {
            throw new IllegalArgumentException("Only mono and stereo are supported");
        }
        if (inputSampleRate < 1) {
            throw new IllegalArgumentException("Sample rate must be greater than 0");
        }
        this.inputSampleRate = inputSampleRate;
        this.inputChannels = inputChannels;
        this.resampleFactor = (double)inputSampleRate / 48000.0;
        this.sourceSamplesNeeded = (int)(960.0 * this.resampleFactor) * inputChannels;
        this.buffer = new CircularShortBuffer(65536);
    }

    public boolean canAdd(int sampleCount) {
        return this.buffer.getFreeSpace() >= sampleCount;
    }

    public void add(short[] samples, int offset, int length) {
        this.buffer.add(samples, offset, length);
    }

    public void add(short[] samples) {
        this.add(samples, 0, samples.length);
    }

    public short[] getFrame() {
        if (this.inputSampleRate == 48000 && this.inputChannels == 1) {
            if (this.buffer.sizeUsed() < 960) {
                Radio.LOGGER.debug("Not enough samples in buffer - waiting");
                return new short[960];
            }
            short[] samples = new short[960];
            this.buffer.get(samples);
            return samples;
        }
        if (this.buffer.sizeUsed() < this.sourceSamplesNeeded) {
            Radio.LOGGER.debug("Not enough samples in buffer - waiting");
            return new short[960];
        }
        short[] convertedAudio = new short[960];
        short[] audioData = new short[this.sourceSamplesNeeded];
        this.buffer.get(audioData);
        for (int i = 0; i < 960; ++i) {
            double sourceIndex = (double)(i * this.inputChannels) * this.resampleFactor;
            int sourceIndexFloor = (int)Math.floor(sourceIndex);
            int sourceIndexCeil = (int)Math.ceil(sourceIndex);
            if (sourceIndexCeil >= audioData.length - this.inputChannels) {
                sourceIndexCeil = audioData.length - this.inputChannels;
                sourceIndexFloor = audioData.length - this.inputChannels - 1;
            } else if (sourceIndexFloor < 0) {
                sourceIndexFloor = 0;
                sourceIndexCeil = 1;
            }
            double fraction = sourceIndex - (double)sourceIndexFloor;
            if (this.inputChannels == 1) {
                convertedAudio[i] = (short)((double)audioData[sourceIndexFloor] + fraction * (double)(audioData[sourceIndexCeil] - audioData[sourceIndexFloor]));
                continue;
            }
            if (this.inputChannels != 2) continue;
            short interpolatedAudioLeft = (short)((double)audioData[sourceIndexFloor] + fraction * (double)(audioData[sourceIndexCeil] - audioData[sourceIndexFloor]));
            short interpolatedAudioRight = (short)((double)audioData[sourceIndexFloor + 1] + fraction * (double)(audioData[sourceIndexCeil + 1] - audioData[sourceIndexFloor + 1]));
            convertedAudio[i] = (short)((interpolatedAudioLeft + interpolatedAudioRight) / 2);
        }
        return convertedAudio;
    }
}

