/*
 * Decompiled with CFR 0.152.
 */
package net.stardomga.stardomsflora.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_7923;

public class FloristRecipeManager {
    private static final Map<ItemPair, class_1799> RECIPES = new HashMap<ItemPair, class_1799>();
    private static final String RECIPE_PATH = "recipes/florist_recipes";

    public static void loadRecipes(class_3300 manager) {
        System.out.println("[Florist Table] Starting recipe loading...");
        System.out.println("[Florist Table] Searching in: recipes/florist_recipes");
        RECIPES.clear();
        System.out.println("\n[Florist Table] All available resources:");
        manager.method_14488("", path -> true).forEach((id, res) -> System.out.println(" - " + String.valueOf(id)));
        class_2960 testId = class_2960.method_60655((String)"stardomsflora", (String)"recipes/florist_recipes/purple_dye.json");
        Optional testResource = manager.method_14486(testId);
        System.out.println("\n[Florist Table] Direct lookup for test recipe '" + String.valueOf(testId) + "': " + (testResource.isPresent() ? "FOUND" : "NOT FOUND"));
        Map resources = manager.method_14488(RECIPE_PATH, path -> path.method_12832().endsWith(".json"));
        System.out.printf("\n[Florist Table] Found %d potential recipe files:\n", resources.size());
        resources.keySet().forEach(id -> System.out.println(" - " + String.valueOf(id)));
        int loadedCount = 0;
        for (Map.Entry entry : resources.entrySet()) {
            class_2960 id2 = (class_2960)entry.getKey();
            System.out.printf("\n[Florist Table] Processing file: %s\n", id2);
            try {
                InputStream stream = ((class_3298)entry.getValue()).method_14482();
                try {
                    JsonObject json = class_3518.method_15255((Reader)new InputStreamReader(stream));
                    System.out.println("File contents:\n" + String.valueOf(json));
                    class_1799 input1 = FloristRecipeManager.parseItemStack(json.get("input1"));
                    class_1799 input2 = FloristRecipeManager.parseItemStack(json.get("input2"));
                    class_1799 output = FloristRecipeManager.parseItemStack(json.get("result"));
                    System.out.printf("Parsed items:\n- Input 1: %s\n- Input 2: %s\n- Output: %s\n", class_7923.field_41178.method_10221((Object)input1.method_7909()), class_7923.field_41178.method_10221((Object)input2.method_7909()), class_7923.field_41178.method_10221((Object)output.method_7909()));
                    if (input1.method_7960() || input2.method_7960() || output.method_7960()) {
                        System.out.println("Skipping - invalid items detected");
                        continue;
                    }
                    RECIPES.put(new ItemPair(input1.method_7909(), input2.method_7909()), output);
                    ++loadedCount;
                    System.out.println("Successfully registered recipe");
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                System.err.printf("FAILED to load recipe %s:\n", id2);
                e.printStackTrace();
            }
        }
        System.out.printf("\n[Florist Table] Loading complete. Successfully loaded %d/%d recipes\n", loadedCount, resources.size());
    }

    private static class_1799 parseItemStack(JsonElement json) {
        try {
            JsonObject obj = json.getAsJsonObject();
            class_2960 itemId = class_2960.method_12829((String)obj.get("item").getAsString());
            if (itemId == null) {
                System.out.println("Invalid item ID in JSON: " + String.valueOf(json));
                return class_1799.field_8037;
            }
            class_1792 item = (class_1792)class_7923.field_41178.method_63535(itemId);
            if (item == class_1802.field_8162) {
                System.out.println("Unknown item: " + String.valueOf(itemId));
                return class_1799.field_8037;
            }
            int count = obj.has("count") ? obj.get("count").getAsInt() : 1;
            return new class_1799((class_1935)item, count);
        }
        catch (Exception e) {
            System.err.println("Failed to parse item stack: " + String.valueOf(json));
            return class_1799.field_8037;
        }
    }

    public static Optional<class_1799> getResult(class_1799 input1, class_1799 input2) {
        if (input1.method_7960() || input2.method_7960()) {
            return Optional.empty();
        }
        ItemPair pair = new ItemPair(input1.method_7909(), input2.method_7909());
        System.out.printf("Checking recipe for: %s + %s\n", class_7923.field_41178.method_10221((Object)input1.method_7909()), class_7923.field_41178.method_10221((Object)input2.method_7909()));
        class_1799 result = RECIPES.get(pair);
        if (result != null) {
            System.out.println("Found matching recipe!");
            return Optional.of(result.method_7972());
        }
        System.out.println("No recipe found");
        return Optional.empty();
    }

    private record ItemPair(class_1792 item1, class_1792 item2) {
        public ItemPair {
            if (item1.hashCode() > item2.hashCode()) {
                class_1792 temp = item1;
                item1 = item2;
                item2 = temp;
            }
        }
    }
}

