/*
 * Decompiled with CFR 0.152.
 */
package net.stardomga.stardomsflora.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_7923;

public class FloristRecipeManager {
    private static final Map<ItemPair, class_1799> RECIPES = new HashMap<ItemPair, class_1799>();
    private static final String RECIPE_PATH = "recipes/florist_recipes";

    public static void loadRecipes(class_3300 manager) {
        RECIPES.clear();
        Map resources = manager.method_14488(RECIPE_PATH, path -> path.method_12832().endsWith(".json"));
        int loadedCount = 0;
        for (Map.Entry entry : resources.entrySet()) {
            class_2960 id = (class_2960)entry.getKey();
            try {
                InputStream stream = ((class_3298)entry.getValue()).method_14482();
                try {
                    JsonObject json = class_3518.method_15255((Reader)new InputStreamReader(stream));
                    class_1799 input1 = FloristRecipeManager.parseItemStack(json.get("input1"));
                    class_1799 input2 = FloristRecipeManager.parseItemStack(json.get("input2"));
                    class_1799 output = FloristRecipeManager.parseItemStack(json.get("result"));
                    if (input1.method_7960() || input2.method_7960() || output.method_7960()) continue;
                    RECIPES.put(new ItemPair(input1.method_7909(), input2.method_7909()), output);
                    ++loadedCount;
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static class_1799 parseItemStack(JsonElement json) {
        try {
            JsonObject obj = json.getAsJsonObject();
            class_2960 itemId = class_2960.method_12829((String)obj.get("item").getAsString());
            if (itemId == null) {
                return class_1799.field_8037;
            }
            class_1792 item = (class_1792)class_7923.field_41178.method_63535(itemId);
            if (item == class_1802.field_8162) {
                return class_1799.field_8037;
            }
            int count = obj.has("count") ? obj.get("count").getAsInt() : 1;
            return new class_1799((class_1935)item, count);
        }
        catch (Exception e) {
            return class_1799.field_8037;
        }
    }

    public static Optional<class_1799> getResult(class_1799 input1, class_1799 input2) {
        if (input1.method_7960() || input2.method_7960()) {
            return Optional.empty();
        }
        ItemPair pair = new ItemPair(input1.method_7909(), input2.method_7909());
        class_1799 result = RECIPES.get(pair);
        if (result != null) {
            return Optional.of(result.method_7972());
        }
        return Optional.empty();
    }

    private record ItemPair(class_1792 item1, class_1792 item2) {
        public ItemPair {
            if (item1.hashCode() > item2.hashCode()) {
                class_1792 temp = item1;
                item1 = item2;
                item2 = temp;
            }
        }
    }
}

