package com.github.wyzzard225.blockyliquids.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import net.minecraft.class_310;

public class ConfigManager {
	 private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
	 private static final File CONFIG_FILE =
					 new File("config/blockyliquids.json");

	 public static boolean load() {
			if (CONFIG_FILE.exists()) {
				 try (FileReader reader = new FileReader(CONFIG_FILE)) {
						Settings.INSTANCE =
										GSON.fromJson(reader, Settings.class);
				 } catch (IOException e) {
						//noinspection CallToPrintStackTrace
						e.printStackTrace();
				 }
				 return true;
			}
			return false;
	 }

	 public static void save() {
			BlockyliquidsClient.console.info("[Blocky Liquids] Saved Config!");
			try (FileWriter writer = new FileWriter(CONFIG_FILE)) {
				 GSON.toJson(Settings.INSTANCE, writer);
			} catch (IOException e) {
				 //noinspection CallToPrintStackTrace
				 e.printStackTrace();
			}
			class_310.method_1551().field_1769.method_3279();
	 }
}