/*
 * Decompiled with CFR 0.152.
 */
package pt.gmsgarcia.smpx.core;

import net.milkbowl.vault.economy.Economy;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;
import pt.gmsgarcia.smpx.core.account.AccountsCache;
import pt.gmsgarcia.smpx.core.commands.CommandRegister;
import pt.gmsgarcia.smpx.core.config.SmpxConfig;
import pt.gmsgarcia.smpx.core.economy.EconomyBridge;
import pt.gmsgarcia.smpx.core.economy.vault.VaultEconomyProvider;
import pt.gmsgarcia.smpx.core.economy.vault.VaultUnlockedEconomyProvider;
import pt.gmsgarcia.smpx.core.listeners.SmpxListeners;
import pt.gmsgarcia.smpx.core.logger.SmpxLogger;
import pt.gmsgarcia.smpx.core.messages.MessageManager;
import pt.gmsgarcia.smpx.core.storage.StorageManager;
import pt.gmsgarcia.smpx.core.user.UsersCache;

public final class SmpxCore
extends JavaPlugin {
    private static SmpxLogger logger;
    private static SmpxConfig config;
    private static MessageManager messages;
    private static StorageManager storage;
    private static EconomyBridge economy;
    private static UsersCache users;
    private static AccountsCache accounts;
    private static VaultEconomyProvider vaultEconomyProvider;
    private static VaultUnlockedEconomyProvider vaultUnlockedEconomyProvider;

    public void onEnable() {
        logger = new SmpxLogger(this.getLogger());
        config = new SmpxConfig();
        config.load();
        messages = new MessageManager();
        messages.load();
        storage = new StorageManager();
        storage.init();
        users = new UsersCache();
        accounts = new AccountsCache();
        economy = new EconomyBridge();
        if (this.getServer().getPluginManager().getPlugin("Vault") != null) {
            try {
                Class.forName("net.milkbowl.vault2.economy.Economy");
                vaultUnlockedEconomyProvider = new VaultUnlockedEconomyProvider();
                this.getServer().getServicesManager().register(net.milkbowl.vault2.economy.Economy.class, (Object)vaultUnlockedEconomyProvider, (Plugin)this, ServicePriority.Highest);
                SmpxCore.logger().info("Hooked into Vault Unlocked as an Economy provider!");
            }
            catch (Exception e) {
                SmpxCore.logger().warning("Unable to connect to Vault Unlocked");
            }
            try {
                Class.forName("net.milkbowl.vault.economy.Economy");
                vaultEconomyProvider = new VaultEconomyProvider();
                this.getServer().getServicesManager().register(Economy.class, (Object)vaultEconomyProvider, (Plugin)this, ServicePriority.Highest);
                SmpxCore.logger().info("Hooked into Vault as an Economy provider!");
            }
            catch (Exception e) {
                SmpxCore.logger().warning("Unable to connect to Vault");
            }
        }
        CommandRegister.registerCommands();
        SmpxListeners.registerListeners();
        logger.info("SmpxCore enabled");
    }

    public void onDisable() {
        SmpxCore.users().save(null);
    }

    public static SmpxCore instance() {
        return (SmpxCore)SmpxCore.getPlugin(SmpxCore.class);
    }

    public static SmpxLogger logger() {
        return logger;
    }

    public static SmpxConfig config() {
        return config;
    }

    public static MessageManager messages() {
        return messages;
    }

    public static StorageManager storage() {
        return storage;
    }

    public static UsersCache users() {
        return users;
    }

    public static AccountsCache accounts() {
        return accounts;
    }

    public static EconomyBridge economy() {
        return economy;
    }
}

