/*
 * Decompiled with CFR 0.152.
 */
package pt.gmsgarcia.smpx.core.account;

import java.math.BigDecimal;
import java.util.UUID;
import pt.gmsgarcia.smpx.core.SmpxCore;
import pt.gmsgarcia.smpx.core.config.CurrencyConfig;
import pt.gmsgarcia.smpx.core.config.EconomyConfig;

public class Account {
    private final UUID uuid;
    private final String name;
    private final String currency;
    private BigDecimal balance;
    private final EconomyConfig econ = SmpxCore.config().economy();
    private final CurrencyConfig config;

    public Account(UUID uuid, String name, String currency, BigDecimal balance) {
        this.uuid = uuid;
        this.name = name;
        this.currency = currency;
        this.balance = balance;
        this.config = SmpxCore.config().economy().currency(currency);
    }

    public UUID uuid() {
        return this.uuid;
    }

    public String name() {
        return this.name;
    }

    public String currency() {
        return this.currency;
    }

    public BigDecimal balance() {
        return this.balance;
    }

    public boolean canAfford(BigDecimal amount) {
        BigDecimal newBalance = this.balance.subtract(amount);
        if (newBalance.compareTo(BigDecimal.ZERO) < 0) {
            if (!this.currency.equals("default")) {
                return false;
            }
            if (!this.econ.allowDebt()) {
                return false;
            }
            if (this.econ.hasMaxDebt()) {
                BigDecimal maxDebt = this.econ.maxDebt();
                return newBalance.compareTo(maxDebt) >= 0;
            }
        }
        return true;
    }

    public void setBalance(BigDecimal amount) {
        this.balance = amount;
    }

    public void deposit(BigDecimal amount) {
        BigDecimal maxBalance;
        if (amount.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        BigDecimal newBalance = this.balance.add(amount);
        if (this.config.hasMaxBalance() && newBalance.compareTo(maxBalance = this.config.maxBalance()) > 0) {
            newBalance = maxBalance;
        }
        this.balance = newBalance;
    }

    public void withdraw(BigDecimal amount) {
        BigDecimal minAmount;
        if (amount.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        if (this.config.hasMinTransactionAmount() && amount.compareTo(minAmount = this.config.minTransactionAmount()) < 0) {
            return;
        }
        if (!this.canAfford(amount)) {
            return;
        }
        this.balance = this.balance.subtract(amount);
    }
}

