/*
 * Decompiled with CFR 0.152.
 */
package pt.gmsgarcia.smpx.core.account;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;
import pt.gmsgarcia.smpx.core.SmpxCore;
import pt.gmsgarcia.smpx.core.account.Account;
import pt.gmsgarcia.smpx.core.config.CurrencyConfig;

public class AccountsCache {
    private final Map<UUID, HashMap<String, Account>> online = new ConcurrentHashMap<UUID, HashMap<String, Account>>();
    private final LoadingCache<UUID, HashMap<String, Account>> cache = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).removalListener(notif -> {
        if (notif.getValue() != null) {
            SmpxCore.storage().layer().saveAccounts((UUID)notif.getKey(), (HashMap)notif.getValue());
            SmpxCore.logger().info("Saved & removed cached accounts with UUID " + String.valueOf(notif.getKey()));
        }
    }).build(new CacheLoader<UUID, HashMap<String, Account>>(this){

        @Override
        @NotNull
        public HashMap<String, Account> load(@NotNull UUID uuid) throws Exception {
            HashMap<String, Account> accounts = SmpxCore.storage().layer().getAccounts(uuid);
            if (accounts == null || accounts.isEmpty()) {
                throw new Exception("Accounts not found for UUID: " + String.valueOf(uuid));
            }
            return accounts;
        }
    });

    public void load(UUID uuid) {
        HashMap<String, Account> accounts;
        if (this.online.containsKey(uuid)) {
            return;
        }
        try {
            accounts = this.cache.getUnchecked(uuid);
        }
        catch (UncheckedExecutionException e) {
            SmpxCore.logger().info("No accounts found with UUID " + String.valueOf(uuid) + ". Creating...");
            accounts = this.create(uuid);
        }
        this.online.put(uuid, accounts);
        SmpxCore.logger().info("Loaded accounts with UUID " + String.valueOf(uuid) + " into online map");
    }

    public void unload(UUID uuid) {
        HashMap<String, Account> accounts = this.online.remove(uuid);
        if (accounts != null) {
            this.cache.put(uuid, accounts);
            SmpxCore.logger().info("Unloaded accounts with UUID " + String.valueOf(uuid));
        }
    }

    public void invalidate(UUID uuid) {
        if (uuid == null) {
            this.cache.invalidateAll();
        } else {
            this.cache.invalidate(uuid);
        }
    }

    public HashMap<String, Account> get(UUID uuid) {
        HashMap<String, Account> accounts = this.online.get(uuid);
        if (accounts != null) {
            return accounts;
        }
        try {
            return this.cache.getUnchecked(uuid);
        }
        catch (Exception e) {
            return null;
        }
    }

    public HashMap<String, Account> create(UUID uuid) {
        return this.create(uuid, Bukkit.getOfflinePlayer((UUID)uuid).getName());
    }

    public HashMap<String, Account> create(UUID uuid, String name) {
        HashMap<String, Account> accounts = new HashMap<String, Account>();
        for (Map.Entry<String, CurrencyConfig> currency : SmpxCore.config().economy().currencies().entrySet()) {
            accounts.put(currency.getKey(), new Account(uuid, name, currency.getKey(), currency.getValue().initialBalance()));
        }
        SmpxCore.storage().layer().createAccounts(uuid, accounts);
        return accounts;
    }

    public void save(UUID uuid) {
        if (uuid == null) {
            this.online.values().forEach(accounts -> SmpxCore.storage().layer().saveAccounts(((Account)accounts.get("default")).uuid(), (HashMap<String, Account>)accounts));
            this.cache.asMap().values().forEach(accounts -> SmpxCore.storage().layer().saveAccounts(((Account)accounts.get("default")).uuid(), (HashMap<String, Account>)accounts));
            return;
        }
        HashMap<String, Account> accounts2 = this.get(uuid);
        if (accounts2 != null) {
            SmpxCore.storage().layer().saveAccounts(uuid, accounts2);
        }
    }
}

