/*
 * Decompiled with CFR 0.152.
 */
package pt.gmsgarcia.smpx.core.commands;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.command.Command;
import org.bukkit.command.PluginCommand;
import org.bukkit.plugin.Plugin;
import pt.gmsgarcia.smpx.core.SmpxCore;

public class CommandsProvider {
    private static Map<String, Command> commands;
    private static List<String> namespaces;
    private static Map<String, Map<String, Command>> commandsByNamespace;

    private CommandsProvider() {
    }

    public static void updateCommands() {
        commands = new HashMap<String, Command>();
        namespaces = new ArrayList<String>();
        commandsByNamespace = new HashMap<String, Map<String, Command>>();
        Map known = SmpxCore.instance().getServer().getCommandMap().getKnownCommands();
        for (Map.Entry<String, Command> entry : known.entrySet()) {
            String namespace = CommandsProvider.extractNamespace(entry);
            if (!namespaces.contains(namespace)) {
                namespaces.add(namespace);
                commandsByNamespace.put(namespace, new HashMap());
            }
            commands.put(entry.getKey(), entry.getValue());
            commandsByNamespace.get(namespace).put(entry.getKey(), entry.getValue());
        }
    }

    public static Map<String, Command> getCommands() {
        return commands;
    }

    public static List<String> getNamespaces() {
        return namespaces;
    }

    public static Map<String, Map<String, Command>> getCommandsByNamespace() {
        return commandsByNamespace;
    }

    private static String extractNamespace(Map.Entry<String, Command> set) {
        Command command = set.getValue();
        String className = command.getClass().getName();
        String namespace = "unknown";
        if (command instanceof PluginCommand) {
            PluginCommand pluginCommand = (PluginCommand)command;
            namespace = pluginCommand.getPlugin().getName();
        } else if (className.startsWith("org.bukkit.craftbukkit.command.VanillaCommandWrapper")) {
            try {
                Field helpCommandNamespaceField = command.getClass().getDeclaredField("helpCommandNamespace");
                helpCommandNamespaceField.setAccessible(true);
                namespace = (String)helpCommandNamespaceField.get(command);
            }
            catch (Exception helpCommandNamespaceField) {}
        } else if (className.startsWith("io.papermc.paper.command.brigadier.PluginVanillaCommandWrapper")) {
            try {
                Field pluginField = command.getClass().getDeclaredField("plugin");
                pluginField.setAccessible(true);
                Plugin plugin = (Plugin)pluginField.get(command);
                namespace = plugin.getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return namespace;
    }
}

