/*
 * Decompiled with CFR 0.152.
 */
package pt.gmsgarcia.smpx.core.commands.dev;

import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import pt.gmsgarcia.smpx.core.SmpxCore;
import pt.gmsgarcia.smpx.core.commands.ISmpxCommand;

public class ReplaceCommand
implements ISmpxCommand {
    public static final String NAME = "replace";
    public static final String DESCRIPTION = "Replace configurations";
    public static final String PERMISSION = "smpx.dev.replace";

    public void execute(CommandSourceStack source, String @NotNull [] args) {
        CommandSender sender = source.getSender();
        if (!sender.hasPermission(PERMISSION)) {
            sender.sendMessage(SmpxCore.messages().component("no-permission", false, new String[0]));
            return;
        }
        String module = "all";
        if (args.length != 0) {
            module = args[0];
        }
        switch (module) {
            case "all": {
                SmpxCore.config().replace();
                SmpxCore.messages().replace();
                break;
            }
            case "config": {
                SmpxCore.config().replace();
                break;
            }
            case "messages": {
                SmpxCore.messages().replace();
                break;
            }
            default: {
                sender.sendMessage(SmpxCore.messages().component("invalid-module", true, new String[0]));
                return;
            }
        }
        if (module.equals("all")) {
            sender.sendMessage(SmpxCore.messages().component("replace-all-success", true, new String[0]));
        } else {
            sender.sendMessage(SmpxCore.messages().component("replace-success", true, "module", module));
        }
    }

    @NotNull
    public Collection<String> suggest(@NotNull CommandSourceStack source, String @NotNull [] args) {
        CommandSender sender = source.getSender();
        List<String> modules = List.of("all", "config", "messages");
        if (sender.hasPermission(PERMISSION)) {
            if (args.length == 0) {
                return modules;
            }
            if (args.length == 1) {
                return modules.stream().filter(name -> name.toLowerCase(Locale.ROOT).startsWith(args[args.length - 1].toLowerCase(Locale.ROOT))).toList();
            }
        }
        return new ArrayList<String>();
    }
}

