/*
 * Decompiled with CFR 0.152.
 */
package pt.gmsgarcia.smpx.core.commands.economy;

import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import pt.gmsgarcia.smpx.core.SmpxCore;
import pt.gmsgarcia.smpx.core.account.Account;
import pt.gmsgarcia.smpx.core.commands.ISmpxCommand;
import pt.gmsgarcia.smpx.core.user.User;

public class AddBalanceCommand
implements ISmpxCommand {
    public static final String NAME = "addbalance";
    public static final String DESCRIPTION = "Add to a player's balance";
    private static final String PERMISSION = "smpx.economy.addbalance";

    public void execute(@NotNull CommandSourceStack source, String @NotNull [] args) {
        BigDecimal amount;
        CommandSender sender = source.getSender();
        if (!sender.hasPermission(PERMISSION)) {
            sender.sendMessage(SmpxCore.messages().component("no-permission", false, new String[0]));
            return;
        }
        String targetName = sender.getName();
        if (args.length == 0) {
            sender.sendMessage(SmpxCore.messages().component("invalid-arguments-count", true, new String[0]));
            return;
        }
        try {
            if (args.length > 1) {
                targetName = args[0];
                amount = new BigDecimal(args[1]);
            } else {
                amount = new BigDecimal(args[0]);
            }
        }
        catch (Exception e) {
            sender.sendMessage(SmpxCore.messages().component("generic-error", true, new String[0]));
            e.printStackTrace();
            return;
        }
        OfflinePlayer targetOfflinePlayer = Bukkit.getOfflinePlayer((String)targetName);
        if (!targetOfflinePlayer.hasPlayedBefore() && !targetOfflinePlayer.isOnline()) {
            sender.sendMessage(SmpxCore.messages().component("player-not-found", true, "player", targetName));
            return;
        }
        User target = SmpxCore.users().get(targetName);
        if (target == null) {
            sender.sendMessage(SmpxCore.messages().component("generic-error", true, new String[0]));
            return;
        }
        Account account = target.account();
        if (account == null) {
            sender.sendMessage(SmpxCore.messages().component("generic-error", true, new String[0]));
            return;
        }
        account.deposit(amount);
        sender.sendMessage(SmpxCore.messages().component("addbalance-sender", true, "receiver", target.name(), "balance", account.balance().toString()));
        if (target.player().isOnline()) {
            sender.sendMessage(SmpxCore.messages().component("addbalance-receiver", true, "balance", account.balance().toString(), "sender", sender.getName()));
        }
    }

    @NotNull
    public Collection<String> suggest(@NotNull CommandSourceStack source, String @NotNull [] args) {
        CommandSender sender = source.getSender();
        if (sender.hasPermission(PERMISSION)) {
            if (args.length == 0) {
                return Bukkit.getOnlinePlayers().stream().map(Player::getName).toList();
            }
            if (args.length == 1) {
                return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase(Locale.ROOT).startsWith(args[args.length - 1].toLowerCase(Locale.ROOT))).toList();
            }
        }
        return new ArrayList<String>();
    }
}

