/*
 * Decompiled with CFR 0.152.
 */
package pt.gmsgarcia.smpx.core.commands.economy;

import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import pt.gmsgarcia.smpx.core.SmpxCore;
import pt.gmsgarcia.smpx.core.account.Account;
import pt.gmsgarcia.smpx.core.commands.ISmpxCommand;
import pt.gmsgarcia.smpx.core.user.User;

public class BalanceCommand
implements ISmpxCommand {
    public static final String NAME = "balance";
    public static final String DESCRIPTION = "Get a player's balance";
    private static final String DEFAULT_PERMISSION = "smpx.economy.balance";
    private static final String ADMIN_PERMISSION = "smpx.economy.balance.*";

    public void execute(CommandSourceStack source, String @NotNull [] args) {
        OfflinePlayer targetOfflinePlayer;
        CommandSender sender = source.getSender();
        if (!sender.hasPermission(DEFAULT_PERMISSION)) {
            sender.sendMessage(SmpxCore.messages().component("no-permission", false, new String[0]));
            return;
        }
        String targetName = sender.getName();
        if (args.length != 0 && sender.hasPermission(ADMIN_PERMISSION) && !(targetOfflinePlayer = Bukkit.getOfflinePlayer((String)(targetName = args[0]))).hasPlayedBefore() && !targetOfflinePlayer.isOnline()) {
            sender.sendMessage(SmpxCore.messages().component("player-not-found", true, "player", targetName));
            return;
        }
        User target = SmpxCore.users().get(targetName);
        if (target == null) {
            sender.sendMessage(SmpxCore.messages().component("generic-error", true, new String[0]));
            return;
        }
        Account account = target.account();
        if (account == null) {
            sender.sendMessage(SmpxCore.messages().component("generic-error", true, new String[0]));
            return;
        }
        sender.sendMessage(SmpxCore.messages().component(NAME, true, NAME, account.balance().toString()));
    }

    @NotNull
    public Collection<String> suggest(@NotNull CommandSourceStack source, String @NotNull [] args) {
        CommandSender sender = source.getSender();
        if (sender.hasPermission(ADMIN_PERMISSION)) {
            if (args.length == 0) {
                return Bukkit.getOnlinePlayers().stream().map(Player::getName).toList();
            }
            if (args.length == 1) {
                return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase(Locale.ROOT).startsWith(args[args.length - 1].toLowerCase(Locale.ROOT))).toList();
            }
        }
        return new ArrayList<String>();
    }
}

