/*
 * Decompiled with CFR 0.152.
 */
package pt.gmsgarcia.smpx.core.commands.tools;

import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import pt.gmsgarcia.smpx.core.SmpxCore;
import pt.gmsgarcia.smpx.core.commands.CommandsProvider;
import pt.gmsgarcia.smpx.core.commands.ISmpxCommand;

public class HelpCommand
implements ISmpxCommand {
    public static final String NAME = "help";
    public static final String DESCRIPTION = "Get a commands's info";
    private static final String PERMISSION = "smpx.tools.help";

    public void execute(CommandSourceStack source, String @NotNull [] args) {
        CommandSender sender = source.getSender();
        if (!sender.hasPermission(PERMISSION)) {
            sender.sendMessage(SmpxCore.messages().component("no-permission", false, new String[0]));
            return;
        }
        if (args.length == 0) {
            sender.sendMessage(this.buildNamespaceListMessage());
            return;
        }
        String matchedNamespace = CommandsProvider.getCommandsByNamespace().keySet().stream().filter(k -> k.equalsIgnoreCase(args[0])).findFirst().orElse(null);
        if (matchedNamespace != null) {
            sender.sendMessage(this.buildCommandListMessage(matchedNamespace));
            return;
        }
        String matchedCommand = CommandsProvider.getCommands().keySet().stream().filter(k -> k.equalsIgnoreCase(args[0])).findFirst().orElse(null);
        if (matchedCommand != null) {
            Command command = CommandsProvider.getCommands().get(matchedCommand);
            sender.sendMessage(this.buildCommandMessage(command));
            return;
        }
        sender.sendMessage(this.buildCommandListMessage(""));
    }

    @NotNull
    public Collection<String> suggest(@NotNull CommandSourceStack source, String @NotNull [] args) {
        Map<String, Map<String, Command>> commandsMap = CommandsProvider.getCommandsByNamespace();
        if (args.length < 1) {
            return CommandsProvider.getCommands().keySet().stream().filter(s -> !s.contains(":")).toList();
        }
        if (args.length == 1) {
            return commandsMap.keySet().stream().filter(k -> k.toLowerCase(Locale.ROOT).startsWith(args[0].toLowerCase(Locale.ROOT))).toList();
        }
        return new ArrayList<String>();
    }

    private Component buildCommandMessage(Command command) {
        TextComponent msg = Component.empty();
        msg = msg.append(SmpxCore.messages().component("help-title-topic", false, "topic", "/" + command.getName())).appendNewline();
        msg = msg.append(SmpxCore.messages().component("help-command-description", false, "description", command.getDescription())).appendNewline();
        msg = msg.append(SmpxCore.messages().component("help-command-usage", false, "usage", command.getUsage()));
        return msg;
    }

    private Component buildNamespaceListMessage() {
        TextComponent msg = Component.empty();
        msg = msg.append(SmpxCore.messages().component("help-title-default", false, new String[0])).appendNewline();
        msg = msg.append(SmpxCore.messages().component("help-tip", false, new String[0])).appendNewline();
        int i = 0;
        for (String namespace : CommandsProvider.getNamespaces()) {
            msg = msg.append(SmpxCore.messages().component("help-list-default", false, "topic", namespace));
            if (++i >= CommandsProvider.getNamespaces().size()) continue;
            msg = msg.appendNewline();
        }
        return msg;
    }

    private Component buildCommandListMessage(String namespace) {
        TextComponent msg = Component.empty();
        Map<String, Command> commands = namespace.isEmpty() ? CommandsProvider.getCommands() : CommandsProvider.getCommandsByNamespace().get(namespace);
        msg = !namespace.isEmpty() ? msg.append(SmpxCore.messages().component("help-title-topic", false, "topic", namespace)).appendNewline() : msg.append(SmpxCore.messages().component("help-title-default", false, new String[0])).appendNewline();
        msg = msg.append(SmpxCore.messages().component("help-tip", false, new String[0])).appendNewline();
        int i = 0;
        for (Map.Entry<String, Command> command : commands.entrySet()) {
            ++i;
            if (command.getKey().contains(":")) continue;
            Component line = SmpxCore.messages().component("help-list-command", false, "command", command.getKey(), "description", command.getValue().getDescription());
            String plain = PlainTextComponentSerializer.plainText().serialize(line);
            if (plain.length() > 60) {
                String wrapped = command.getValue().getDescription().substring(0, command.getValue().getDescription().length() - (plain.length() - 57)) + "...";
                line = SmpxCore.messages().component("help-list-command", false, "command", command.getKey(), "description", wrapped);
            }
            msg = msg.append(line);
            if (i >= commands.size() - 1) continue;
            msg = msg.appendNewline();
        }
        return msg;
    }
}

