/*
 * Decompiled with CFR 0.152.
 */
package pt.gmsgarcia.smpx.core.commands.tools;

import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import pt.gmsgarcia.smpx.core.SmpxCore;
import pt.gmsgarcia.smpx.core.commands.ISmpxCommand;
import pt.gmsgarcia.smpx.core.user.User;
import pt.gmsgarcia.smpx.core.user.Username;

public class WhoIsCommand
implements ISmpxCommand {
    public static final String NAME = "whois";
    public static final String DESCRIPTION = "Get a player's info";
    private static final String DEFAULT_PERMISSION = "smpx.tools.whois";
    private static final String ADMIN_PERMISSION = "smpx.tools.whois.*";
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");

    public void execute(CommandSourceStack source, String @NotNull [] args) {
        String targetName;
        CommandSender sender = source.getSender();
        if (!sender.hasPermission(DEFAULT_PERMISSION)) {
            sender.sendMessage(SmpxCore.messages().component("no-permission", false, new String[0]));
            return;
        }
        if (args.length == 0 && source.getSender() instanceof ConsoleCommandSender) {
            sender.sendMessage(SmpxCore.messages().component("invalid-sender", true, new String[0]));
            return;
        }
        String string = targetName = args.length > 0 ? args[0] : sender.getName();
        if (!targetName.equals(sender.getName()) && !sender.hasPermission(ADMIN_PERMISSION)) {
            sender.sendMessage(SmpxCore.messages().component("no-permission", true, new String[0]));
            return;
        }
        OfflinePlayer targetOfflinePlayer = Bukkit.getOfflinePlayer((String)targetName);
        if (!targetOfflinePlayer.hasPlayedBefore() && !targetOfflinePlayer.isOnline()) {
            sender.sendMessage(SmpxCore.messages().component("player-not-found", true, "player", targetName));
            return;
        }
        UUID uuid = targetOfflinePlayer.getUniqueId();
        User target = SmpxCore.users().get(uuid);
        if (target == null) {
            sender.sendMessage(SmpxCore.messages().component("player-not-found", true, new String[0]));
            return;
        }
        sender.sendMessage(WhoIsCommand.buildMessage(sender, target));
    }

    @NotNull
    public Collection<String> suggest(CommandSourceStack source, String @NotNull [] args) {
        CommandSender sender = source.getSender();
        if (sender.hasPermission(ADMIN_PERMISSION)) {
            if (args.length == 0) {
                return Bukkit.getOnlinePlayers().stream().map(Player::getName).toList();
            }
            if (args.length == 1) {
                return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase(Locale.ROOT).startsWith(args[args.length - 1].toLowerCase(Locale.ROOT))).toList();
            }
        }
        return new ArrayList<String>();
    }

    private static String buildMessage(CommandSender sender, User target) {
        LocalDateTime lastSeen = LocalDateTime.ofInstant(Instant.ofEpochMilli(target.lastSeen()), ZoneId.systemDefault());
        LocalDateTime joinDate = LocalDateTime.ofInstant(Instant.ofEpochMilli(target.joinDate()), ZoneId.systemDefault());
        StringBuilder message = new StringBuilder(target.name() + (String)(sender.hasPermission(ADMIN_PERMISSION) ? " : " + String.valueOf(target.uuid()) + "\n" : "\n"));
        message.append("Last seen: ").append(lastSeen.format(DATE_TIME_FORMATTER)).append("\n");
        if (sender.hasPermission(ADMIN_PERMISSION)) {
            message.append("Join date: ").append(joinDate.format(DATE_TIME_FORMATTER)).append("\n");
            if (target.previousNames() != null && !target.previousNames().isEmpty()) {
                message.append("Usernames: \n");
                LocalDateTime lastUsage = LocalDateTime.ofInstant(Instant.ofEpochMilli(target.previousNames().getFirst().lastUsage()), ZoneId.systemDefault());
                message.append(target.name()).append(" (since ").append(lastUsage.format(DATE_TIME_FORMATTER)).append(")").append("\n");
                for (Username p : target.previousNames()) {
                    lastUsage = LocalDateTime.ofInstant(Instant.ofEpochMilli(p.lastUsage()), ZoneId.systemDefault());
                    message.append(p.name()).append(" (last usage ").append(lastUsage.format(DATE_TIME_FORMATTER)).append(")").append("\n");
                }
            }
        }
        message = new StringBuilder(message.substring(0, message.length() - 1));
        return message.toString();
    }
}

