/*
 * Decompiled with CFR 0.152.
 */
package pt.gmsgarcia.smpx.core.config;

import java.io.File;
import org.bukkit.configuration.file.YamlConfiguration;
import pt.gmsgarcia.smpx.core.SmpxCore;
import pt.gmsgarcia.smpx.core.config.EconomyConfig;
import pt.gmsgarcia.smpx.core.config.StorageConfig;

public class SmpxConfig {
    private File file;
    private YamlConfiguration config;
    private EconomyConfig economy;
    private StorageConfig storage;

    public void load() {
        this.file = new File(SmpxCore.instance().getDataFolder(), "config.yml");
        if (!this.file.exists()) {
            SmpxCore.instance().saveResource("config.yml", false);
        }
        this.config = new YamlConfiguration();
        this.config.options().parseComments(true);
        try {
            this.config = YamlConfiguration.loadConfiguration((File)this.file);
            SmpxCore.logger().info("Config loaded");
        }
        catch (Exception e) {
            SmpxCore.logger().severe("Failed to load config: " + e.getMessage());
        }
        this.economy = new EconomyConfig(this.config);
        this.storage = new StorageConfig(this.config);
    }

    public void replace() {
        SmpxCore.instance().saveResource("config.yml", true);
        this.load();
    }

    public void save() {
        try {
            this.config.save(this.file);
            SmpxCore.logger().info("Config saved");
        }
        catch (Exception e) {
            SmpxCore.logger().severe("Failed to save config: " + e.getMessage());
        }
    }

    public EconomyConfig economy() {
        return this.economy;
    }

    public StorageConfig storage() {
        return this.storage;
    }
}

