/*
 * Decompiled with CFR 0.152.
 */
package pt.gmsgarcia.smpx.core.economy.vault;

import java.math.BigDecimal;
import java.util.List;
import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import pt.gmsgarcia.smpx.core.SmpxCore;

public class VaultEconomyProvider
implements Economy {
    public boolean isEnabled() {
        return SmpxCore.economy().isEnabled();
    }

    public String getName() {
        return SmpxCore.economy().getName();
    }

    public int fractionalDigits() {
        return SmpxCore.economy().fractionalDigits();
    }

    public String format(double amount) {
        return SmpxCore.economy().format(BigDecimal.valueOf(amount));
    }

    public String currencyNamePlural() {
        return SmpxCore.economy().currencyNamePlural("default");
    }

    public String currencyNameSingular() {
        return SmpxCore.economy().currencyNameSingular("default");
    }

    public boolean hasAccount(String playerName) {
        UUID uuid = Bukkit.getPlayerUniqueId((String)playerName);
        return SmpxCore.economy().hasAccount(uuid);
    }

    public boolean hasAccount(OfflinePlayer player) {
        UUID uuid = player.getUniqueId();
        return SmpxCore.economy().hasAccount(uuid);
    }

    public boolean hasAccount(String playerName, String worldName) {
        UUID uuid = Bukkit.getPlayerUniqueId((String)playerName);
        return SmpxCore.economy().hasAccount(uuid);
    }

    public boolean hasAccount(OfflinePlayer player, String worldName) {
        UUID uuid = player.getUniqueId();
        return SmpxCore.economy().hasAccount(uuid);
    }

    public double getBalance(String playerName) {
        UUID uuid = Bukkit.getPlayerUniqueId((String)playerName);
        return SmpxCore.economy().getBalance(uuid).doubleValue();
    }

    public double getBalance(OfflinePlayer player) {
        UUID uuid = player.getUniqueId();
        return SmpxCore.economy().getBalance(uuid).doubleValue();
    }

    public double getBalance(String playerName, String world) {
        UUID uuid = Bukkit.getPlayerUniqueId((String)playerName);
        return SmpxCore.economy().getBalance(uuid).doubleValue();
    }

    public double getBalance(OfflinePlayer player, String world) {
        UUID uuid = player.getUniqueId();
        return SmpxCore.economy().getBalance(uuid).doubleValue();
    }

    public boolean has(String playerName, double amount) {
        UUID uuid = Bukkit.getPlayerUniqueId((String)playerName);
        return SmpxCore.economy().has(uuid, amount);
    }

    public boolean has(OfflinePlayer player, double amount) {
        UUID uuid = player.getUniqueId();
        return SmpxCore.economy().has(uuid, amount);
    }

    public boolean has(String playerName, String worldName, double amount) {
        UUID uuid = Bukkit.getPlayerUniqueId((String)playerName);
        return SmpxCore.economy().has(uuid, amount);
    }

    public boolean has(OfflinePlayer player, String worldName, double amount) {
        UUID uuid = player.getUniqueId();
        return SmpxCore.economy().has(uuid, amount);
    }

    public EconomyResponse withdrawPlayer(String playerName, double amount) {
        UUID uuid = Bukkit.getPlayerUniqueId((String)playerName);
        return SmpxCore.economy().withdrawAccount(uuid, amount);
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer player, double amount) {
        UUID uuid = player.getUniqueId();
        return SmpxCore.economy().withdrawAccount(uuid, amount);
    }

    public EconomyResponse withdrawPlayer(String playerName, String worldName, double amount) {
        UUID uuid = Bukkit.getPlayerUniqueId((String)playerName);
        return SmpxCore.economy().withdrawAccount(uuid, amount);
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer player, String worldName, double amount) {
        UUID uuid = player.getUniqueId();
        return SmpxCore.economy().withdrawAccount(uuid, amount);
    }

    public EconomyResponse depositPlayer(String playerName, double amount) {
        UUID uuid = Bukkit.getPlayerUniqueId((String)playerName);
        return SmpxCore.economy().depositAccount(uuid, amount);
    }

    public EconomyResponse depositPlayer(OfflinePlayer player, double amount) {
        UUID uuid = player.getUniqueId();
        return SmpxCore.economy().depositAccount(uuid, amount);
    }

    public EconomyResponse depositPlayer(String playerName, String worldName, double amount) {
        UUID uuid = Bukkit.getPlayerUniqueId((String)playerName);
        return SmpxCore.economy().depositAccount(uuid, amount);
    }

    public EconomyResponse depositPlayer(OfflinePlayer player, String worldName, double amount) {
        UUID uuid = player.getUniqueId();
        return SmpxCore.economy().depositAccount(uuid, amount);
    }

    public boolean createPlayerAccount(String playerName) {
        UUID uuid = Bukkit.getPlayerUniqueId((String)playerName);
        return SmpxCore.economy().createAccount(uuid, playerName);
    }

    public boolean createPlayerAccount(OfflinePlayer player) {
        UUID uuid = player.getUniqueId();
        String playerName = player.getName();
        return SmpxCore.economy().createAccount(uuid, playerName);
    }

    public boolean createPlayerAccount(String playerName, String worldName) {
        UUID uuid = Bukkit.getPlayerUniqueId((String)playerName);
        return SmpxCore.economy().createAccount(uuid, playerName);
    }

    public boolean createPlayerAccount(OfflinePlayer player, String worldName) {
        UUID uuid = player.getUniqueId();
        String playerName = player.getName();
        return SmpxCore.economy().createAccount(uuid, playerName);
    }

    public boolean hasBankSupport() {
        return false;
    }

    public EconomyResponse createBank(String name, String player) {
        return null;
    }

    public EconomyResponse createBank(String name, OfflinePlayer player) {
        return null;
    }

    public EconomyResponse deleteBank(String name) {
        return null;
    }

    public EconomyResponse bankBalance(String name) {
        return null;
    }

    public EconomyResponse bankHas(String name, double amount) {
        return null;
    }

    public EconomyResponse bankWithdraw(String name, double amount) {
        return null;
    }

    public EconomyResponse bankDeposit(String name, double amount) {
        return null;
    }

    public EconomyResponse isBankOwner(String name, String playerName) {
        return null;
    }

    public EconomyResponse isBankOwner(String name, OfflinePlayer player) {
        return null;
    }

    public EconomyResponse isBankMember(String name, String playerName) {
        return null;
    }

    public EconomyResponse isBankMember(String name, OfflinePlayer player) {
        return null;
    }

    public List<String> getBanks() {
        return List.of();
    }
}

