/*
 * Decompiled with CFR 0.152.
 */
package pt.gmsgarcia.smpx.core.economy.vault;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.milkbowl.vault2.economy.AccountPermission;
import net.milkbowl.vault2.economy.Economy;
import net.milkbowl.vault2.economy.EconomyResponse;
import org.jetbrains.annotations.NotNull;
import pt.gmsgarcia.smpx.core.SmpxCore;

public class VaultUnlockedEconomyProvider
implements Economy {
    public boolean isEnabled() {
        return SmpxCore.economy().isEnabled();
    }

    @NotNull
    public String getName() {
        return SmpxCore.economy().getName();
    }

    public boolean hasSharedAccountSupport() {
        return false;
    }

    public boolean hasMultiCurrencySupport() {
        return false;
    }

    public int fractionalDigits(@NotNull String pluginName) {
        return SmpxCore.economy().fractionalDigits();
    }

    @NotNull
    public String format(@NotNull BigDecimal amount) {
        return SmpxCore.economy().format(amount);
    }

    @NotNull
    public String format(@NotNull String pluginName, @NotNull BigDecimal amount) {
        return SmpxCore.economy().format(amount);
    }

    @NotNull
    public String format(@NotNull BigDecimal amount, @NotNull String currency) {
        return SmpxCore.economy().format(amount);
    }

    @NotNull
    public String format(@NotNull String pluginName, @NotNull BigDecimal amount, @NotNull String currency) {
        return SmpxCore.economy().format(amount);
    }

    public boolean hasCurrency(@NotNull String currency) {
        return SmpxCore.economy().hasCurrency(currency);
    }

    @NotNull
    public String getDefaultCurrency(@NotNull String pluginName) {
        return SmpxCore.economy().currency("default");
    }

    @NotNull
    public String defaultCurrencyNamePlural(@NotNull String pluginName) {
        return SmpxCore.economy().currencyNamePlural("default");
    }

    @NotNull
    public String defaultCurrencyNameSingular(@NotNull String pluginName) {
        return SmpxCore.economy().currencyNameSingular("default");
    }

    @NotNull
    public Collection<String> currencies() {
        return SmpxCore.economy().currencies();
    }

    public boolean createAccount(@NotNull UUID accountID, @NotNull String name) {
        return SmpxCore.economy().createAccount(accountID, name);
    }

    public boolean createAccount(@NotNull UUID accountID, @NotNull String name, boolean player) {
        return SmpxCore.economy().createAccount(accountID, name);
    }

    public boolean createAccount(@NotNull UUID accountID, @NotNull String name, @NotNull String worldName) {
        return SmpxCore.economy().createAccount(accountID, name);
    }

    public boolean createAccount(@NotNull UUID accountID, @NotNull String name, @NotNull String worldName, boolean player) {
        return SmpxCore.economy().createAccount(accountID, name);
    }

    @NotNull
    public Map<UUID, String> getUUIDNameMap() {
        return Map.of();
    }

    public Optional<String> getAccountName(@NotNull UUID accountID) {
        return SmpxCore.economy().getAccountName(accountID);
    }

    public boolean hasAccount(@NotNull UUID accountID) {
        return SmpxCore.economy().hasAccount(accountID);
    }

    public boolean hasAccount(@NotNull UUID accountID, @NotNull String worldName) {
        return SmpxCore.economy().hasAccount(accountID);
    }

    public boolean renameAccount(@NotNull UUID accountID, @NotNull String name) {
        return false;
    }

    public boolean renameAccount(@NotNull String plugin, @NotNull UUID accountID, @NotNull String name) {
        return false;
    }

    public boolean deleteAccount(@NotNull String plugin, @NotNull UUID accountID) {
        return false;
    }

    public boolean accountSupportsCurrency(@NotNull String plugin, @NotNull UUID accountID, @NotNull String currency) {
        return SmpxCore.economy().currencies().contains(currency);
    }

    public boolean accountSupportsCurrency(@NotNull String plugin, @NotNull UUID accountID, @NotNull String currency, @NotNull String world) {
        return SmpxCore.economy().currencies().contains(currency);
    }

    @NotNull
    public BigDecimal getBalance(@NotNull String pluginName, @NotNull UUID accountID) {
        return SmpxCore.economy().getBalance(accountID);
    }

    @NotNull
    public BigDecimal getBalance(@NotNull String pluginName, @NotNull UUID accountID, @NotNull String world) {
        return SmpxCore.economy().getBalance(accountID);
    }

    @NotNull
    public BigDecimal getBalance(@NotNull String pluginName, @NotNull UUID accountID, @NotNull String world, @NotNull String currency) {
        return SmpxCore.economy().getBalance(accountID, currency);
    }

    public boolean has(@NotNull String pluginName, @NotNull UUID accountID, @NotNull BigDecimal amount) {
        return SmpxCore.economy().has(accountID, amount.doubleValue());
    }

    public boolean has(@NotNull String pluginName, @NotNull UUID accountID, @NotNull String worldName, @NotNull BigDecimal amount) {
        return SmpxCore.economy().has(accountID, amount.doubleValue());
    }

    public boolean has(@NotNull String pluginName, @NotNull UUID accountID, @NotNull String worldName, @NotNull String currency, @NotNull BigDecimal amount) {
        return SmpxCore.economy().has(accountID, currency, amount.doubleValue());
    }

    @NotNull
    public EconomyResponse withdraw(@NotNull String pluginName, @NotNull UUID accountID, @NotNull BigDecimal amount) {
        return SmpxCore.economy().withdrawAccountUnlocked(accountID, amount);
    }

    @NotNull
    public EconomyResponse withdraw(@NotNull String pluginName, @NotNull UUID accountID, @NotNull String worldName, @NotNull BigDecimal amount) {
        return SmpxCore.economy().withdrawAccountUnlocked(accountID, amount);
    }

    @NotNull
    public EconomyResponse withdraw(@NotNull String pluginName, @NotNull UUID accountID, @NotNull String worldName, @NotNull String currency, @NotNull BigDecimal amount) {
        return SmpxCore.economy().withdrawAccountUnlocked(accountID, currency, amount);
    }

    @NotNull
    public EconomyResponse deposit(@NotNull String pluginName, @NotNull UUID accountID, @NotNull BigDecimal amount) {
        return SmpxCore.economy().depositAccountUnlocked(accountID, amount);
    }

    @NotNull
    public EconomyResponse deposit(@NotNull String pluginName, @NotNull UUID accountID, @NotNull String worldName, @NotNull BigDecimal amount) {
        return SmpxCore.economy().depositAccountUnlocked(accountID, amount);
    }

    @NotNull
    public EconomyResponse deposit(@NotNull String pluginName, @NotNull UUID accountID, @NotNull String worldName, @NotNull String currency, @NotNull BigDecimal amount) {
        return SmpxCore.economy().depositAccountUnlocked(accountID, currency, amount);
    }

    public boolean createSharedAccount(@NotNull String pluginName, @NotNull UUID accountID, @NotNull String name, @NotNull UUID owner) {
        return false;
    }

    public boolean isAccountOwner(@NotNull String pluginName, @NotNull UUID accountID, @NotNull UUID uuid) {
        return false;
    }

    public boolean setOwner(@NotNull String pluginName, @NotNull UUID accountID, @NotNull UUID uuid) {
        return false;
    }

    public boolean isAccountMember(@NotNull String pluginName, @NotNull UUID accountID, @NotNull UUID uuid) {
        return false;
    }

    public boolean addAccountMember(@NotNull String pluginName, @NotNull UUID accountID, @NotNull UUID uuid) {
        return false;
    }

    public boolean addAccountMember(@NotNull String pluginName, @NotNull UUID accountID, @NotNull UUID uuid, AccountPermission ... initialPermissions) {
        return false;
    }

    public boolean removeAccountMember(@NotNull String pluginName, @NotNull UUID accountID, @NotNull UUID uuid) {
        return false;
    }

    public boolean hasAccountPermission(@NotNull String pluginName, @NotNull UUID accountID, @NotNull UUID uuid, @NotNull AccountPermission permission) {
        return false;
    }

    public boolean updateAccountPermission(@NotNull String pluginName, @NotNull UUID accountID, @NotNull UUID uuid, @NotNull AccountPermission permission, boolean value) {
        return false;
    }
}

