/*
 * Decompiled with CFR 0.152.
 */
package pt.gmsgarcia.smpx.core.messages;

import java.io.File;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.configuration.file.YamlConfiguration;
import pt.gmsgarcia.smpx.core.SmpxCore;

public class MessageManager {
    private YamlConfiguration messages;

    public void load() {
        File file = new File(SmpxCore.instance().getDataFolder(), "messages.yml");
        if (!file.exists()) {
            SmpxCore.instance().saveResource("messages.yml", false);
        }
        this.messages = new YamlConfiguration();
        this.messages.options().parseComments(true);
        try {
            this.messages = YamlConfiguration.loadConfiguration((File)file);
            SmpxCore.logger().info("Messages loaded");
        }
        catch (Exception e) {
            SmpxCore.logger().severe("Failed to load messages: " + e.getMessage());
        }
    }

    public void replace() {
        SmpxCore.instance().saveResource("messages.yml", true);
        this.load();
    }

    public String get(String url) {
        String msg = this.messages.getString("messages." + url);
        if (msg == null) {
            return "Missing message: " + url;
        }
        return msg;
    }

    public String prefix() {
        String prefix = this.messages.getString("prefix");
        if (prefix == null) {
            prefix = "[smpx-core] ";
        }
        return prefix;
    }

    public Component component(String path, boolean prefix, String ... placeholders) {
        Object msg = this.get(path);
        for (int i = 0; i < placeholders.length - 1; i += 2) {
            msg = ((String)msg).replace("%" + placeholders[i] + "%", placeholders[i + 1]);
        }
        if (prefix) {
            msg = this.prefix() + (String)msg;
        }
        return MiniMessage.miniMessage().deserialize(msg);
    }
}

