/*
 * Decompiled with CFR 0.152.
 */
package pt.gmsgarcia.smpx.core.storage.layers;

import java.util.HashMap;
import java.util.UUID;
import pt.gmsgarcia.smpx.core.SmpxCore;
import pt.gmsgarcia.smpx.core.account.Account;
import pt.gmsgarcia.smpx.core.config.StorageConfig;
import pt.gmsgarcia.smpx.core.storage.IStorageLayer;
import pt.gmsgarcia.smpx.core.storage.layers.sql.DatabaseManager;
import pt.gmsgarcia.smpx.core.storage.layers.sql.dao.AccountDAO;
import pt.gmsgarcia.smpx.core.storage.layers.sql.dao.UserDAO;
import pt.gmsgarcia.smpx.core.storage.layers.sql.dao.UsernameDAO;
import pt.gmsgarcia.smpx.core.user.User;

public class MySQLStorage
implements IStorageLayer {
    private DatabaseManager db;
    private UserDAO userDao;
    private AccountDAO accountDao;
    private UsernameDAO usernameDao;

    @Override
    public void init() {
        StorageConfig.MySQLConfig cfg = SmpxCore.config().storage().mysql();
        this.db = new DatabaseManager(cfg);
        this.userDao = new UserDAO(this.db);
        this.accountDao = new AccountDAO(this.db);
        this.usernameDao = new UsernameDAO(this.db);
    }

    @Override
    public User getUser(UUID uuid) {
        return this.userDao.load(uuid);
    }

    @Override
    public HashMap<String, Account> getAccounts(UUID uuid) {
        return this.accountDao.load(uuid);
    }

    @Override
    public void saveUser(User user) {
        if (user == null) {
            return;
        }
        this.userDao.save(user);
    }

    @Override
    public void saveAccounts(UUID uuid, HashMap<String, Account> accounts) {
        if (accounts == null || accounts.isEmpty()) {
            return;
        }
        this.accountDao.save(uuid, accounts);
    }

    @Override
    public void createUser(User user) {
        this.userDao.create(user);
    }

    @Override
    public void createAccounts(UUID uuid, HashMap<String, Account> accounts) {
        this.accountDao.create(uuid, accounts);
    }

    @Override
    public void createPreviousUsername(User user) {
        this.usernameDao.create(user);
    }
}

