/*
 * Decompiled with CFR 0.152.
 */
package pt.gmsgarcia.smpx.core.user;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import pt.gmsgarcia.smpx.core.SmpxCore;
import pt.gmsgarcia.smpx.core.account.Account;
import pt.gmsgarcia.smpx.core.config.CurrencyConfig;
import pt.gmsgarcia.smpx.core.user.Username;

public class User {
    private final OfflinePlayer player;
    private final UUID uuid;
    private String name;
    private final long joinDate;
    private long lastSeen;
    private final HashMap<String, Account> accounts;
    private final ArrayList<Username> previousNames;

    private User(UUID uuid, String name, long joinDate, long lastSeen, ArrayList<Username> previousNames) {
        this.uuid = uuid;
        this.name = name;
        this.joinDate = joinDate;
        this.lastSeen = lastSeen;
        this.previousNames = previousNames != null ? previousNames : new ArrayList();
        HashMap<String, Account> accounts = SmpxCore.accounts().get(uuid);
        if (accounts == null) {
            this.accounts = new HashMap();
            for (Map.Entry<String, CurrencyConfig> currency : SmpxCore.config().economy().currencies().entrySet()) {
                this.accounts.put(currency.getKey(), new Account(uuid, name, currency.getKey(), currency.getValue().initialBalance()));
            }
            SmpxCore.storage().layer().createAccounts(uuid, this.accounts());
        } else {
            this.accounts = accounts;
        }
        this.player = Bukkit.getOfflinePlayer((UUID)uuid);
    }

    public static User build(UUID uuid, String name) {
        return User.build(uuid, name, System.currentTimeMillis(), -1L, null);
    }

    public static User build(UUID uuid, String name, long joinDate, long lastSeen, ArrayList<Username> previousNames) {
        return new User(uuid, name, joinDate, lastSeen, previousNames);
    }

    public OfflinePlayer player() {
        return this.player;
    }

    public boolean isOnline() {
        return this.player.isOnline();
    }

    public UUID uuid() {
        return this.uuid;
    }

    public String name() {
        return this.name;
    }

    public Account account() {
        return this.accounts.get("default");
    }

    public Account account(String name) {
        return this.accounts.get(name);
    }

    public HashMap<String, Account> accounts() {
        return this.accounts;
    }

    public long joinDate() {
        return this.joinDate;
    }

    public long lastSeen() {
        return this.lastSeen;
    }

    public ArrayList<Username> previousNames() {
        return this.previousNames;
    }

    public void updateName(String name) {
        this.previousNames.add(new Username(this.name, this.lastSeen));
        this.name = name;
    }

    public void setLastSeen(long timestamp) {
        this.lastSeen = timestamp;
    }
}

