/*
 * Decompiled with CFR 0.152.
 */
package pt.gmsgarcia.smpx.core.user;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import pt.gmsgarcia.smpx.core.SmpxCore;
import pt.gmsgarcia.smpx.core.user.User;

public class UsersCache {
    private final Map<UUID, User> online = new ConcurrentHashMap<UUID, User>();
    private final LoadingCache<UUID, User> cache = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).removalListener(notification -> {
        if (notification.getValue() != null) {
            SmpxCore.storage().layer().saveUser((User)notification.getValue());
            SmpxCore.logger().info("Saved & removed cached user: " + String.valueOf(notification.getKey()));
        }
    }).build(new CacheLoader<UUID, User>(this){

        @Override
        @NotNull
        public User load(@NotNull UUID uuid) throws Exception {
            User user = SmpxCore.storage().layer().getUser(uuid);
            if (user == null) {
                throw new Exception("User not found for UUID: " + String.valueOf(uuid));
            }
            return user;
        }
    });

    public void load(Player player) {
        User user;
        UUID uuid = player.getUniqueId();
        if (this.online.containsKey(uuid)) {
            return;
        }
        try {
            user = this.cache.getUnchecked(uuid);
            if (!user.name().equals(player.getName())) {
                SmpxCore.storage().layer().createPreviousUsername(user);
                user.updateName(player.getName());
            }
        }
        catch (UncheckedExecutionException e) {
            user = this.create(uuid);
        }
        this.online.put(uuid, user);
        SmpxCore.logger().info("Loaded user into online map: " + player.getName());
    }

    public void unload(UUID uuid) {
        User user = this.online.remove(uuid);
        if (user != null) {
            user.setLastSeen(System.currentTimeMillis());
            this.cache.put(uuid, user);
            SmpxCore.logger().info("Unloaded user from online map: " + user.name());
        }
    }

    public void invalidate(UUID uuid) {
        if (uuid == null) {
            this.cache.invalidateAll();
        } else {
            this.cache.invalidate(uuid);
        }
    }

    public User get(String name) {
        return this.get(Bukkit.getPlayerUniqueId((String)name));
    }

    public User get(UUID uuid) {
        User user = this.online.get(uuid);
        if (user != null) {
            return user;
        }
        try {
            return this.cache.getUnchecked(uuid);
        }
        catch (Exception e) {
            return null;
        }
    }

    public User create(UUID uuid) {
        OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)uuid);
        User user = User.build(uuid, player.getName());
        SmpxCore.storage().layer().createUser(user);
        return user;
    }

    public void save(UUID uuid) {
        if (uuid == null) {
            this.online.values().forEach(user -> SmpxCore.storage().layer().saveUser((User)user));
            this.cache.asMap().values().forEach(user -> SmpxCore.storage().layer().saveUser((User)user));
            SmpxCore.accounts().save(null);
            return;
        }
        User user2 = this.get(uuid);
        if (user2 != null) {
            SmpxCore.storage().layer().saveUser(user2);
            SmpxCore.accounts().save(uuid);
        }
    }
}

