/*
 * Decompiled with CFR 0.152.
 */
package cn.alini.safefarmland;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;

@Mod(value="safefarmland")
public class Safefarmland {
    public static final String MODID = "safefarmland";
    private static Block AQUA_FARMLAND = null;
    private static Block TFC_FARMLAND = null;
    private static boolean PROTECT_ENABLED = true;
    private static boolean DEBUG_ENABLED = false;

    public Safefarmland() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::onCommonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new FarmlandTrampleHandler());
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.addListener(e -> e.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sf").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"toggle").requires(src -> src.m_6761_(2))).executes(ctx -> {
            PROTECT_ENABLED = !PROTECT_ENABLED;
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a73[Safefarmland] \u4fdd\u62a4\u5df2 " + (PROTECT_ENABLED ? "\u5f00\u542f" : "\u5173\u95ed"))), true);
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"debug").requires(src -> src.m_6761_(2))).executes(ctx -> {
            DEBUG_ENABLED = !DEBUG_ENABLED;
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a73[Safefarmland] \u8c03\u8bd5\u5df2 " + (DEBUG_ENABLED ? "\u5f00\u542f" : "\u5173\u95ed"))), true);
            return 1;
        }))));
    }

    private static void resolveCompatFarmland() {
        ResourceLocation tfcId;
        ResourceLocation aquaId;
        if (AQUA_FARMLAND == null && ForgeRegistries.BLOCKS.containsKey(aquaId = new ResourceLocation("aquaculture", "farmland"))) {
            AQUA_FARMLAND = (Block)ForgeRegistries.BLOCKS.getValue(aquaId);
        }
        if (TFC_FARMLAND == null && ForgeRegistries.BLOCKS.containsKey(tfcId = new ResourceLocation("tfc", "farmland"))) {
            TFC_FARMLAND = (Block)ForgeRegistries.BLOCKS.getValue(tfcId);
        }
    }

    private static boolean isProtectedFarmland(Block block) {
        if (block instanceof FarmBlock) {
            return true;
        }
        Safefarmland.resolveCompatFarmland();
        return block == AQUA_FARMLAND || block == TFC_FARMLAND || block == Blocks.f_50093_;
    }

    public static class FarmlandTrampleHandler {
        @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=false)
        public void onFarmlandTrample(BlockEvent.FarmlandTrampleEvent event) {
            LevelAccessor levelAccessor = event.getLevel();
            if (!(levelAccessor instanceof ServerLevel)) {
                return;
            }
            ServerLevel level = (ServerLevel)levelAccessor;
            if (!PROTECT_ENABLED) {
                return;
            }
            Entity entity = event.getEntity();
            if (!(entity instanceof Player) && !(entity instanceof Animal)) {
                if (DEBUG_ENABLED && entity instanceof Player) {
                    Player p = (Player)entity;
                    p.m_213846_((Component)Component.m_237113_((String)("\u00a73[Safefarmland][\u8c03\u8bd5] \u975e\u73a9\u5bb6/\u52a8\u7269\u5b9e\u4f53\u8e29\u8e0f: " + entity.m_6095_())));
                }
                return;
            }
            event.setCanceled(true);
            entity.m_183634_();
            if (DEBUG_ENABLED && entity instanceof Player) {
                Player p = (Player)entity;
                Block eventBlock = event.getState().m_60734_();
                Block worldBlock = level.m_8055_(event.getPos()).m_60734_();
                String eventId = ForgeRegistries.BLOCKS.getKey((Object)eventBlock) != null ? ForgeRegistries.BLOCKS.getKey((Object)eventBlock).toString() : "unknown";
                String worldId = ForgeRegistries.BLOCKS.getKey((Object)worldBlock) != null ? ForgeRegistries.BLOCKS.getKey((Object)worldBlock).toString() : "unknown";
                p.m_213846_((Component)Component.m_237113_((String)("\u00a73[Safefarmland][\u8c03\u8bd5] \u5df2\u963b\u6b62\u8015\u5730\u8e29\u8e0f | eventState=" + eventId + " | worldState=" + worldId)));
            }
        }
    }
}

