/*
 * Decompiled with CFR 0.152.
 */
package de.additions;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import de.additions.Additions;
import de.additions.config.AdditionsConfig;
import de.additions.helper.DownloadHelper;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_11555;
import net.minecraft.class_155;
import net.minecraft.class_3264;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u000f\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\t\u0010\u0003J\u000f\u0010\n\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\n\u0010\u0003J\u000f\u0010\u000b\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000b\u0010\u0003J\u000f\u0010\f\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\f\u0010\u0003J\u000f\u0010\r\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\r\u0010\u0003R\u0014\u0010\u000f\u001a\u00020\u000e8\u0000X\u0080T\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000e8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u000e8\u0000X\u0080T\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0013\u001a\u00020\u000e8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0010R\u0014\u0010\u0015\u001a\u00020\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u000e8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lde/additions/ModTranslations;", "", "<init>", "()V", "", "startTranslationDownload", "", "shouldCheckForTranslations", "()Z", "processTranslations", "extractTranslationFiles", "createResourcePackMetadata", "copyModIconAsPackIcon", "enableResourcePack", "", "RESOURCEPACK_NAME", "Ljava/lang/String;", "RESOURCEPACK_DIR", "DESTINATION", "ZIP_PATH", "", "DOWNLOAD_INTERVAL", "I", "TRANSLATION_URL", "additions"})
@SourceDebugExtension(value={"SMAP\nModTranslations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModTranslations.kt\nde/additions/ModTranslations\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,318:1\n1#2:319\n1321#3,2:320\n*S KotlinDebug\n*F\n+ 1 ModTranslations.kt\nde/additions/ModTranslations\n*L\n151#1:320,2\n*E\n"})
public final class ModTranslations {
    @NotNull
    public static final ModTranslations INSTANCE = new ModTranslations();
    @NotNull
    public static final String RESOURCEPACK_NAME = "\u00a7badditions\u00a7r \u00a76Translations\u00a7r";
    @NotNull
    private static final String RESOURCEPACK_DIR = "resourcepacks/\u00a7badditions\u00a7r \u00a76Translations\u00a7r";
    @NotNull
    public static final String DESTINATION = "resourcepacks/\u00a7badditions\u00a7r \u00a76Translations\u00a7r/assets/additions/lang";
    @NotNull
    private static final String ZIP_PATH = "resourcepacks/\u00a7badditions\u00a7r \u00a76Translations\u00a7r/assets/additions/lang.zip";
    private static final int DOWNLOAD_INTERVAL = AdditionsConfig.TranslationCounter;
    @NotNull
    private static final String TRANSLATION_URL = "https://github.com/LufatZ/dayofmind-translation-download/releases/latest/download/dayofmind-translation.zip";

    private ModTranslations() {
    }

    public final void startTranslationDownload() {
        if (!this.shouldCheckForTranslations()) {
            if (Additions.INSTANCE.getLogging()) {
                Additions.INSTANCE.getLogger().info("Skipping translation check on this launch.");
            }
            return;
        }
        Additions.INSTANCE.getLogger().info("Starting translation download and installation process");
        boolean download = DownloadHelper.INSTANCE.downloadFile$additions(TRANSLATION_URL, ZIP_PATH);
        try {
            if (download) {
                if (Additions.INSTANCE.getLogging()) {
                    Additions.INSTANCE.getLogger().info("Translation pack downloaded successfully");
                }
                this.processTranslations();
            } else {
                Additions.INSTANCE.getLogger().error("Failed to download translation pack from: https://github.com/LufatZ/dayofmind-translation-download/releases/latest/download/dayofmind-translation.zip");
            }
        }
        catch (Exception e) {
            Additions.INSTANCE.getLogger().error("Error during translation process: " + e.getMessage(), (Throwable)e);
        }
        Additions.INSTANCE.getLogger().info("Translation process completed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean shouldCheckForTranslations() {
        Closeable it;
        Path configDir = FabricLoader.getInstance().getConfigDir();
        File counterFile = configDir.resolve("additions-translation-counter.properties").toFile();
        Properties properties = new Properties();
        if (counterFile.exists()) {
            try {
                Intrinsics.checkNotNull((Object)counterFile);
                Closeable closeable = new FileInputStream(counterFile);
                Throwable throwable = null;
                try {
                    it = (FileInputStream)closeable;
                    boolean bl = false;
                    properties.load((InputStream)it);
                    it = Unit.INSTANCE;
                }
                catch (Throwable bl) {
                    throwable = bl;
                    throw bl;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Exception e) {
                Additions.INSTANCE.getLogger().warn("Could not read translation properties, resetting: " + e.getMessage());
            }
        }
        String string = properties.getProperty("launchCount", "0");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        Integer n = StringsKt.toIntOrNull((String)string);
        int currentCount = n != null ? n : 0;
        int newCount = currentCount + 1;
        properties.setProperty("launchCount", String.valueOf(newCount));
        try {
            Intrinsics.checkNotNull((Object)counterFile);
            it = new FileOutputStream(counterFile);
            Throwable bl = null;
            try {
                FileOutputStream it2 = (FileOutputStream)it;
                boolean bl2 = false;
                properties.store(it2, "Mod translation launch counter");
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                bl = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)it, (Throwable)bl);
            }
        }
        catch (Exception e) {
            Additions.INSTANCE.getLogger().error("Could not save translation properties: " + e.getMessage(), (Throwable)e);
        }
        Path path = Paths.get(RESOURCEPACK_DIR, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path resourcePackDir = path;
        if (!Files.exists(resourcePackDir, new LinkOption[0])) {
            Additions.INSTANCE.getLogger().info("Resource pack directory not found, forcing translation check.");
            return true;
        }
        boolean isCheckDay = newCount % DOWNLOAD_INTERVAL == 1;
        return isCheckDay;
    }

    private final void processTranslations() {
        this.extractTranslationFiles();
        this.createResourcePackMetadata();
        this.enableResourcePack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void extractTranslationFiles() {
        if (Additions.INSTANCE.getLogging()) {
            Additions.INSTANCE.getLogger().info("Extracting translation files to: resourcepacks/\u00a7badditions\u00a7r \u00a76Translations\u00a7r/assets/additions/lang");
        }
        try {
            Closeable closeable = new ZipFile(ZIP_PATH);
            Throwable throwable = null;
            try {
                void $this$forEach$iv;
                ZipFile zip = (ZipFile)closeable;
                boolean bl = false;
                Enumeration<? extends ZipEntry> enumeration = zip.entries();
                Intrinsics.checkNotNullExpressionValue(enumeration, (String)"entries(...)");
                Sequence sequence = SequencesKt.filter((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration)), ModTranslations::extractTranslationFiles$lambda$6$lambda$2);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ZipEntry entry = (ZipEntry)element$iv;
                    boolean bl2 = false;
                    String string = entry.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    String string2 = string.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                    File outputFile = new File(DESTINATION, string2);
                    File file = outputFile.getParentFile();
                    if (file != null) {
                        file.mkdirs();
                    }
                    Closeable closeable2 = zip.getInputStream(entry);
                    Throwable throwable2 = null;
                    try {
                        long l;
                        InputStream input = (InputStream)closeable2;
                        boolean bl3 = false;
                        Closeable closeable3 = new FileOutputStream(outputFile);
                        Throwable throwable3 = null;
                        try {
                            FileOutputStream output = (FileOutputStream)closeable3;
                            boolean bl4 = false;
                            Intrinsics.checkNotNull((Object)input);
                            l = ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)output, (int)0, (int)2, null);
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                        }
                        long l2 = l;
                    }
                    catch (Throwable throwable5) {
                        throwable2 = throwable5;
                        throw throwable5;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                    if (!Additions.INSTANCE.getLogging()) continue;
                    Additions.INSTANCE.getLogger().info("Extracted: " + entry.getName() + " -> " + outputFile.getPath());
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            if (!new File(ZIP_PATH).delete() && Additions.INSTANCE.getLogging()) {
                Additions.INSTANCE.getLogger().warn("Could not delete temporary ZIP file: resourcepacks/\u00a7badditions\u00a7r \u00a76Translations\u00a7r/assets/additions/lang.zip");
            }
            if (Additions.INSTANCE.getLogging()) {
                Additions.INSTANCE.getLogger().info("Translation files extracted successfully");
            }
        }
        catch (Exception e) {
            Additions.INSTANCE.getLogger().error("Failed to extract translation files: " + e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private final void createResourcePackMetadata() {
        Path path = Paths.get(RESOURCEPACK_DIR, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path packMcMetaPath = path.resolve("pack.mcmeta");
        class_11555 currentPackFormat = class_155.method_16673().method_70592(class_3264.field_14188);
        String packMetadata = StringsKt.trimIndent((String)("\n            {\n                \"pack\": {\n                    \"pack_format\": " + currentPackFormat + ",\n                    \"min_format\": " + currentPackFormat + ",\n                    \"max_format\": " + currentPackFormat + ",\n                    \"description\": \"\u00a77Community translations from crowdin for additions\"\n                }\n            }\n        "));
        try {
            Files.writeString(packMcMetaPath, (CharSequence)packMetadata, new OpenOption[0]);
            if (Additions.INSTANCE.getLogging()) {
                Additions.INSTANCE.getLogger().info("Created pack.mcmeta at: " + packMcMetaPath + " with pack_format: " + currentPackFormat);
            }
        }
        catch (Exception e) {
            Additions.INSTANCE.getLogger().error("Failed to create pack.mcmeta: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        this.copyModIconAsPackIcon();
    }

    private final void copyModIconAsPackIcon() {
        block8: {
            Path path = Paths.get(RESOURCEPACK_DIR, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            Path packIconPath = path.resolve("pack.png");
            String iconPath = "assets/additions/icon.png";
            try {
                Path iconResource;
                block7: {
                    Path path2;
                    Object t = FabricLoader.getInstance().getModContainer("additions").get();
                    Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
                    ModContainer mod = (ModContainer)t;
                    List list = mod.getRootPaths();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRootPaths(...)");
                    for (Path rootPath : (Iterable)list) {
                        boolean bl = false;
                        Path iconFile = rootPath.resolve(iconPath);
                        Path path3 = Files.exists(iconFile, new LinkOption[0]) ? iconFile : null;
                        if (path3 == null) continue;
                        path2 = path3;
                        break block7;
                    }
                    path2 = iconResource = null;
                }
                if (iconResource != null) {
                    CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                    Files.copy(iconResource, packIconPath, copyOptionArray);
                    if (Additions.INSTANCE.getLogging()) {
                        Additions.INSTANCE.getLogger().info("Updated pack icon from mod");
                    }
                } else if (Additions.INSTANCE.getLogging()) {
                    Additions.INSTANCE.getLogger().info("Mod icon not found at " + iconPath + ", using default pack icon");
                }
            }
            catch (Exception e) {
                if (!Additions.INSTANCE.getLogging()) break block8;
                Additions.INSTANCE.getLogger().warn("Could not copy mod icon: " + e.getMessage());
            }
        }
    }

    private final void enableResourcePack() {
        File optionsFile = FabricLoader.getInstance().getGameDir().resolve("options.txt").toFile();
        String manualEnablePackLog = "Please manually enable the '\u00a7badditions\u00a7r \u00a76Translations\u00a7r' resource pack in-game";
        if (!optionsFile.exists()) {
            Additions.INSTANCE.getLogger().warn("options.txt not found - resource pack cannot be enabled automatically");
            Additions.INSTANCE.getLogger().info(manualEnablePackLog);
            return;
        }
        try {
            Intrinsics.checkNotNull((Object)optionsFile);
            List lines = CollectionsKt.toMutableList((Collection)FilesKt.readLines$default((File)optionsFile, null, (int)1, null));
            String packIdentifier = "file/\u00a7badditions\u00a7r \u00a76Translations\u00a7r";
            boolean resourcePackLineFound = false;
            boolean wasModified = false;
            int n = ((Collection)lines).size();
            for (int i = 0; i < n; ++i) {
                if (!StringsKt.startsWith$default((String)((String)lines.get(i)), (String)"resourcePacks:", (boolean)false, (int)2, null)) continue;
                resourcePackLineFound = true;
                String currentPacksJson = StringsKt.substringAfter$default((String)((String)lines.get(i)), (String)"resourcePacks:", null, (int)2, null);
                if (StringsKt.contains$default((CharSequence)currentPacksJson, (CharSequence)("\"" + packIdentifier + "\""), (boolean)false, (int)2, null)) {
                    Additions.INSTANCE.getLogger().info("Translation resource pack is already enabled");
                    return;
                }
                Gson gson = new Gson();
                Type listType2 = new TypeToken<List<String>>(){}.getType();
                Object object = gson.fromJson(currentPacksJson, listType2);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
                List currentPacks = (List)object;
                if (currentPacks.contains(packIdentifier)) break;
                currentPacks.add(packIdentifier);
                lines.set(i, "resourcePacks:" + gson.toJson((Object)currentPacks));
                wasModified = true;
                if (!Additions.INSTANCE.getLogging()) break;
                Additions.INSTANCE.getLogger().info("Added translation pack to resource pack list");
                break;
            }
            if (!resourcePackLineFound) {
                Additions.INSTANCE.getLogger().warn("'resourcePacks' entry not found in options.txt - cannot enable automatically");
                Additions.INSTANCE.getLogger().info(manualEnablePackLog);
                return;
            }
            if (wasModified) {
                Iterable iterable = lines;
                String string = System.lineSeparator();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineSeparator(...)");
                FilesKt.writeText$default((File)optionsFile, (String)CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, null, (int)62, null), null, (int)2, null);
                Additions.INSTANCE.getLogger().info("Successfully enabled translation resource pack");
            }
        }
        catch (Exception e) {
            Additions.INSTANCE.getLogger().error("Failed to enable resource pack in options.txt: " + e.getMessage(), (Throwable)e);
            Additions.INSTANCE.getLogger().info(manualEnablePackLog);
        }
    }

    private static final boolean extractTranslationFiles$lambda$6$lambda$2(ZipEntry it) {
        return !it.isDirectory();
    }
}

