/*
 * Decompiled with CFR 0.152.
 */
package de.additions.helper;

import de.additions.Additions;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\n\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b\b\u0010\t\u00a8\u0006\u000b"}, d2={"Lde/additions/helper/DownloadHelper;", "", "<init>", "()V", "", "urlString", "destinationPath", "", "downloadFile$additions", "(Ljava/lang/String;Ljava/lang/String;)Z", "downloadFile", "additions"})
public final class DownloadHelper {
    @NotNull
    public static final DownloadHelper INSTANCE = new DownloadHelper();

    private DownloadHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean downloadFile$additions(@NotNull String urlString, @NotNull String destinationPath) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        Intrinsics.checkNotNullParameter((Object)destinationPath, (String)"destinationPath");
        Additions.INSTANCE.getLogger().info("Starting download from: " + urlString);
        try {
            Path destinationFile = Paths.get(destinationPath, new String[0]);
            Path parentDirectory = destinationFile.getParent();
            if (parentDirectory != null && !Files.exists(parentDirectory, new LinkOption[0])) {
                if (Additions.INSTANCE.getLogging()) {
                    Additions.INSTANCE.getLogger().info("Creating directory: " + parentDirectory);
                }
                Files.createDirectories(parentDirectory, new FileAttribute[0]);
            }
            URL url = new URI(urlString).toURL();
            Closeable closeable = url.openStream();
            Throwable throwable = null;
            try {
                long l;
                InputStream inputStream = (InputStream)closeable;
                boolean bl2 = false;
                Closeable closeable2 = Channels.newChannel(inputStream);
                Throwable throwable2 = null;
                try {
                    long l2;
                    ReadableByteChannel readableByteChannel = (ReadableByteChannel)closeable2;
                    boolean bl3 = false;
                    Closeable closeable3 = new FileOutputStream(destinationPath);
                    Throwable throwable3 = null;
                    try {
                        FileOutputStream fileOutputStream = (FileOutputStream)closeable3;
                        boolean bl4 = false;
                        l2 = fileOutputStream.getChannel().transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                    }
                    l = l2;
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                long l3 = l;
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Additions.INSTANCE.getLogger().info("Download completed successfully!");
            if (Additions.INSTANCE.getLogging()) {
                Additions.INSTANCE.getLogger().info("\u2713 Download saved to: " + destinationFile.toAbsolutePath());
            }
            bl = true;
        }
        catch (Exception e) {
            if (Additions.INSTANCE.getLogging()) {
                Additions.INSTANCE.getLogger().error("Error downloading file from: " + urlString, (Throwable)e);
            }
            Additions.INSTANCE.getLogger().warn("\u2717 Download failed: " + e.getMessage());
            bl = false;
        }
        return bl;
    }
}

