/*
 * Decompiled with CFR 0.152.
 */
package de.additions.mixin;

import de.additions.blocks.BlockRegistry;
import de.additions.config.AdditionsConfig;
import de.additions.datagen.BlockTagGenerator;
import net.minecraft.class_1821;
import net.minecraft.class_1838;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2680;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_2778;
import net.minecraft.class_3481;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={class_1821.class})
public abstract class AdditionsShovelMixin {
    @Unique
    private static final Logger logger = LoggerFactory.getLogger((String)"DayOfMind Additions - Shovel Mixin");
    @Unique
    private static final class_2248 FALLBACK_STAIR = class_2246.field_10563;
    @Unique
    private static final class_2248 FALLBACK_SLAB = class_2246.field_10119;

    @ModifyVariable(method={"method_7884(Lnet/minecraft/class_1838;)Lnet/minecraft/class_1269;"}, at=@At(value="STORE", ordinal=0), index=6, require=1)
    private class_2680 injectCustomPathStates(class_2680 originalBlockState2, class_1838 context) {
        class_2680 targetState;
        class_2680 clickedBlockState;
        if (originalBlockState2 == null && AdditionsConfig.EnabledShovelMixin && ((clickedBlockState = context.method_8045().method_8320(context.method_8037())).method_26164(class_3481.field_29822) || clickedBlockState.method_26164(BlockTagGenerator.Companion.getDirtLikeBlockTag()) || clickedBlockState.method_26164(BlockTagGenerator.Companion.getDirtPathVariantTag()) || clickedBlockState.method_26204() == class_2246.field_10194) && (targetState = AdditionsShovelMixin.getTargetState(clickedBlockState)) != null && targetState != clickedBlockState) {
            logger.debug("Shovel Mixin: Transforming {} to {}", (Object)class_7923.field_41175.method_10221((Object)clickedBlockState.method_26204()), (Object)class_7923.field_41175.method_10221((Object)targetState.method_26204()));
            return targetState;
        }
        return originalBlockState2;
    }

    @Unique
    @Nullable
    private static class_2680 getTargetState(class_2680 source) {
        class_2680 target = source;
        try {
            logger.info("Shovel Mixin: Attempting to transform {}", (Object)class_7923.field_41175.method_10221((Object)source.method_26204()));
            class_2248 dirtPathStairsBlock = BlockRegistry.INSTANCE.getDIRT_PATH_STAIR();
            class_2248 dirtPathSlabBlock = BlockRegistry.INSTANCE.getDIRT_PATH_SLAB();
            class_2248 dirtStairsBlock = BlockRegistry.INSTANCE.getDIRT_STAIR();
            class_2248 dirtSlabBlock = BlockRegistry.INSTANCE.getDIRT_SLAB();
            class_2680 stairPathState = dirtPathStairsBlock.method_9564();
            class_2680 slabPathState = dirtPathSlabBlock.method_9564();
            class_2680 stairDirtState = dirtStairsBlock.method_9564();
            class_2680 slabDirtState = dirtSlabBlock.method_9564();
            class_2248 sourceBlock = source.method_26204();
            if (sourceBlock instanceof class_2510) {
                class_2680 potentialTargetState = sourceBlock == dirtPathStairsBlock ? stairDirtState : stairPathState;
                target = (class_2680)((class_2680)((class_2680)((class_2680)potentialTargetState.method_11657((class_2769)class_2510.field_11571, (Comparable)((class_2350)source.method_11654((class_2769)class_2510.field_11571)))).method_11657((class_2769)class_2510.field_11572, (Comparable)((class_2760)source.method_11654((class_2769)class_2510.field_11572)))).method_11657((class_2769)class_2510.field_11565, (Comparable)((class_2778)source.method_11654((class_2769)class_2510.field_11565)))).method_11657((class_2769)class_2510.field_11573, (Comparable)((Boolean)source.method_11654((class_2769)class_2510.field_11573)));
            } else if (sourceBlock instanceof class_2482) {
                class_2680 potentialTargetState = sourceBlock == dirtPathSlabBlock ? slabDirtState : slabPathState;
                target = (class_2680)((class_2680)potentialTargetState.method_11657((class_2769)class_2482.field_11501, (Comparable)((class_2771)source.method_11654((class_2769)class_2482.field_11501)))).method_11657((class_2769)class_2482.field_11502, (Comparable)((Boolean)source.method_11654((class_2769)class_2482.field_11502)));
            } else if (sourceBlock == class_2246.field_10194) {
                target = class_2246.field_10566.method_9564();
            }
            class_2248 targetBlock = target.method_26204();
            if (target != source && (targetBlock == FALLBACK_STAIR || targetBlock == FALLBACK_SLAB)) {
                logger.warn("Shovel Mixin: Prevented transformation of {} into fallback block {}. Target block likely not registered correctly.", (Object)class_7923.field_41175.method_10221((Object)sourceBlock), (Object)class_7923.field_41175.method_10221((Object)targetBlock));
                target = source;
            }
        }
        catch (IllegalArgumentException e) {
            logger.error("Failed to transfer block state properties from {}: {}", (Object)class_7923.field_41175.method_10221((Object)source.method_26204()), (Object)e.getMessage());
            target = source;
        }
        catch (Exception e) {
            logger.error("Unexpected error during getTargetState for {}: {}", new Object[]{class_7923.field_41175.method_10221((Object)source.method_26204()), e.getMessage(), e});
            return null;
        }
        return target;
    }
}

