#version 150

#moj_import <minecraft:fog.glsl>
#moj_import <minecraft:dynamictransforms.glsl>

uniform sampler2D Sampler0;

in float sphericalVertexDistance;
in float cylindricalVertexDistance;
in vec4 vertexColor;
in vec2 texCoord0;
in vec2 texCoord1;

out vec4 fragColor;

void main() {
    vec4 baseColor = texture(Sampler0, texCoord0);
    vec4 color = baseColor * vertexColor * ColorModulator;

    if (color.a < 0.1) {
        discard;
    }

    vec4 vanillaColor = apply_fog(color,
        sphericalVertexDistance,
        cylindricalVertexDistance,
        FogEnvironmentalStart,
        FogEnvironmentalEnd,
        FogRenderDistanceStart,
        FogRenderDistanceEnd,
        FogColor
    );

    if (baseColor.a > 0.996 && baseColor.a < 0.999) {
        vec3 emissive = baseColor.rgb * 1.8;
        vanillaColor.rgb = mix(vanillaColor.rgb, emissive, 0.85);
    }

    fragColor = vanillaColor;
}