package com.github.thedeathlycow.frostiful.block;

import com.github.thedeathlycow.frostiful.registry.FBlockProperties;
import com.mojang.serialization.MapCodec;
import net.minecraft.class_1297;
import net.minecraft.class_1750;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2373;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class BrittleIceBlock extends class_2373 {

    public static final MapCodec<BrittleIceBlock> CODEC = method_54094(BrittleIceBlock::new);

    public static final class_2758 CRACKING = FBlockProperties.CRACKING;

    public static final class_2746 FROZEN = FBlockProperties.FROZEN;

    public BrittleIceBlock(class_2251 settings) {
        super(settings);
        this.method_9590(
                this.method_9564()
                        .method_11657(CRACKING, 0)
                        .method_11657(FROZEN, false)
        );
    }

    @Override
    public MapCodec<BrittleIceBlock> method_53969() {
        return field_46366;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(CRACKING, FROZEN);
    }

    @Override
    public void method_9591(class_1937 world, class_2338 pos, class_2680 state, class_1297 entity) {
        if (!world.method_8608() && BrittleIce.canCrackIce(entity)) {
            world.method_64310(pos, this, BrittleIce.getCrackDelay(world.method_8409()));
        }
    }

    @Override
    protected void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (!state.method_27852(this)) {
            return;
        }
        BrittleIce.crack(this, state, world, pos, random);
    }

    @Nullable
    @Override
    public class_2680 method_9605(class_1750 ctx) {
        class_2680 base = super.method_9605(ctx);

        if (base == null) {
            return null;
        }

        class_3610 fluidState = ctx.method_8045().method_8316(ctx.method_8037());
        return base.method_11657(FROZEN, fluidState.method_39360(class_3612.field_15910));
    }
}