package com.github.thedeathlycow.frostiful.block;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.config.FrostifulConfig;
import com.github.thedeathlycow.frostiful.registry.FBlocks;
import com.github.thedeathlycow.frostiful.registry.FCriteria;
import com.github.thedeathlycow.frostiful.registry.FSoundEvents;
import com.github.thedeathlycow.frostiful.registry.tag.FItemTags;
import com.github.thedeathlycow.thermoo.api.temperature.HeatingModes;
import net.fabricmc.fabric.api.registry.LandPathNodeTypesRegistry;
import net.minecraft.class_10774;
import net.minecraft.class_10776;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_5777;
import net.minecraft.class_5819;
import net.minecraft.class_7;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;

public class SunLichenBlock extends class_5777 implements Heatable {

    public static final int COLD_LEVEL = 0;
    public static final int COOL_LEVEL = 1;
    public static final int WARM_LEVEL = 2;
    public static final int HOT_LEVEL = 3;


    private static final float BASE_GROW_CHANCE = 0.017f;
    private static final float RANDOM_DISCHARGE_CHANCE = 0.13f;

    private final int heatLevel;

    public SunLichenBlock(int heatLevel, class_2251 settings) {
        super(settings);
        this.heatLevel = heatLevel;
        if (heatLevel > COLD_LEVEL) {
            LandPathNodeTypesRegistry.register(this, class_7.field_17, class_7.field_17);
        }
    }

    @Override
    protected void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity, class_10774 handler) {
        if (this.heatLevel > COLD_LEVEL && entity instanceof class_1309 livingEntity && this.canBurnEntity(entity)) {
            this.dischargeHeatToEntity(state, world, pos, livingEntity, handler, Frostiful.getConfig());
        }

        super.method_9548(state, world, pos, entity, handler);
    }

    private void dischargeHeatToEntity(
            class_2680 state,
            class_1937 world,
            class_2338 pos,
            class_1309 entity,
            class_10774 handler,
            FrostifulConfig config
    ) {
        int heatToDischarge = config.freezingConfig.getSunLichenHeatPerLevel() * this.heatLevel;

        // burn if hot sun lichen and target is warm
        if (entity.thermoo$getTemperature() > 0 && this.heatLevel == HOT_LEVEL) {
            final int fireTicks = config.freezingConfig.getSunLichenBurnTime();
            handler.method_67638(class_10776.field_56643);
            handler.method_67640(class_10776.field_56643, e -> e.method_20803(fireTicks));
        } else if (entity.thermoo$isCold()) { // only add heatToDischarge if cold, but always damage
            entity.thermoo$addTemperature(heatToDischarge, HeatingModes.ACTIVE);

            // reset temperature if temp change overheated
            if (entity.thermoo$isWarm()) {
                entity.thermoo$setTemperature(0);
            }
        }

        entity.method_64419(world.method_48963().method_48820(), 1f);
        if (entity instanceof class_3222 player) {
            FCriteria.SUN_LICHEN_DISCHARGE.trigger(player, heatToDischarge);
        }

        createFireParticles(world, pos);

        class_2680 coldSunLichenState = FBlocks.COLD_SUN_LICHEN.method_34725(state);
        world.method_8501(pos, coldSunLichenState);

        playSound(world, pos);
    }

    @Override
    protected void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        int skyLight = world.method_8314(class_1944.field_9284, pos);
        if ((skyLight > 0 && world.method_8530()) && world.method_8409().method_43057() < this.getChargeChance(skyLight)) {
            Optional<class_2680> nextState = Heatable.getNextState(state);
            nextState.ifPresent(blockState -> world.method_8501(pos, blockState));
        } else if ((skyLight == 0) && world.method_8409().method_43057() < RANDOM_DISCHARGE_CHANCE) {
            Optional<class_2680> previousState = Heatable.getPreviousState(state);
            previousState.ifPresent(blockState -> world.method_8501(pos, blockState));
        }
    }

    @Override
    protected boolean method_9616(class_2680 state, class_1750 context) {

        class_1799 toPlace = context.method_8041();

        boolean isDifferentSunLichen = toPlace.method_31573(FItemTags.SUN_LICHENS) && !toPlace.method_31574(this.method_8389());

        if (isDifferentSunLichen) {
            return false;
        }

        return super.method_9616(state, context);
    }

    @Override
    public int getHeatLevel() {
        return this.heatLevel;
    }

    private float getChargeChance(int skyLight) {
        return BASE_GROW_CHANCE * skyLight;
    }

    private boolean canBurnEntity(class_1297 entity) {
        if (entity.method_7325() || (entity instanceof class_1657 player && player.method_68878())) {
            return false;
        } else if (entity.method_5753()) {
            return false;
        } else {
            return true;
        }
    }

    private static void playSound(class_1937 world, class_2338 pos) {
        if (world.method_8608()) {
            return;
        }
        class_5819 random = world.method_8409();
        float pitch = 0.8F + (random.method_43057() - random.method_43057()) * 0.4F;
        world.method_8396(null, pos, FSoundEvents.FIRE_LICHEN_DISCHARGE, class_3419.field_15245, 0.7F, pitch);
    }

    private static void createFireParticles(class_1937 world, class_2338 pos) {
        final double maxHorizontalOffset = 0.5;

        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int i = 0; i < 10; i++) {
            double x = pos.method_10263() + 0.5;
            double y = pos.method_10264() + random.nextDouble(0.33);
            double z = pos.method_10260() + 0.5;
            x += random.nextDouble(-maxHorizontalOffset, maxHorizontalOffset);
            z += random.nextDouble(-maxHorizontalOffset, maxHorizontalOffset);
            world.method_8406(class_2398.field_11240, x, y, z, 0.0D, 0.1D, 0.0D);
        }
    }
}
