package com.github.thedeathlycow.frostiful.client.mixin.entity_renderer;

import com.github.thedeathlycow.frostiful.client.render.state.FLivingEntityRenderState;
import com.github.thedeathlycow.frostiful.registry.FComponents;
import com.github.thedeathlycow.frostiful.survival.SurvivalUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10042;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_1309;
import net.minecraft.class_2246;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_776;
import net.minecraft.class_922;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_922.class)
@Environment(EnvType.CLIENT)
public class LivingEntityRendererMixin<T extends class_1309, S extends class_10042, M extends class_583<? super S>> {
    @Unique
    private class_776 frostiful$blockRenderManager;

    @Inject(
            method = "<init>",
            at = @At("TAIL")
    )
    private void initAddon(class_5617.class_5618 ctx, M model, float shadowRadius, CallbackInfo ci) {
        this.frostiful$blockRenderManager = ctx.method_43337();
    }

    @Inject(
            method = "updateRenderState(Lnet/minecraft/entity/LivingEntity;Lnet/minecraft/client/render/entity/state/LivingEntityRenderState;F)V",
            at = @At("TAIL")
    )
    private void updateRenderState(T entity, S state, float f, CallbackInfo ci) {
        boolean isRooted = FComponents.FROST_WAND_ROOT_COMPONENT.get(entity).isRooted();
        ((FLivingEntityRenderState) state).frostiful$isRooted(isRooted);

        boolean shaking = state.field_53456;
        if (SurvivalUtils.isShiveringRender(entity)) {
            state.field_53456 = true;
        } else {
            state.field_53456 = shaking;
        }
    }

    @Inject(
            method = "render(Lnet/minecraft/client/render/entity/state/LivingEntityRenderState;Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/command/OrderedRenderCommandQueue;Lnet/minecraft/client/render/state/CameraRenderState;)V",
            at = @At(
                    value = "TAIL"
            )
    )
    private void renderIceOnEntity(
            S state,
            class_4587 matrices,
            class_11659 queue,
            class_12075 cameraState,
            CallbackInfo ci
    ) {
        if (((FLivingEntityRenderState) state).frostiful$isRooted()) {
            matrices.method_22903();
            float blockSize = 1.75f;
            matrices.method_22905(
                    blockSize * state.field_53329,
                    blockSize * state.field_53330,
                    blockSize * state.field_53329
            );
            matrices.method_22904(-0.5, -0.3, -0.5);

            queue.method_73481(
                    matrices,
                    class_2246.field_10295.method_9564(),
                    state.field_61820,
                    class_4608.field_21444,
                    state.field_61821
            );

            matrices.method_22909();
        }
    }
}
