package com.github.thedeathlycow.frostiful.client.particle;

import com.github.thedeathlycow.frostiful.particle.HeatDrainParticleEffect;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_243;
import net.minecraft.class_3940;
import net.minecraft.class_4002;
import net.minecraft.class_4955;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.client.particle.*;
import org.jetbrains.annotations.Nullable;

import java.util.concurrent.ThreadLocalRandom;

@Environment(EnvType.CLIENT)
public class HeatDrainParticle extends class_4955 {
    protected HeatDrainParticle(
            class_638 clientWorld,
            double x, double y, double z,
            double vx, double vy, double vz,
            class_4002 spriteProvider,
            class_243 destination
    ) {
        super(clientWorld, x, y, z, vx, vy, vz, spriteProvider.method_74304());

        this.field_3852 = destination.field_1352 - this.field_3874;
        this.field_3869 = destination.field_1351 - this.field_3854;
        this.field_3850 = destination.field_1350 - this.field_3871;

        final double slowFactor = 0.1;

        this.field_3852 *= slowFactor * this.field_28786;
        this.field_3869 *= slowFactor * this.field_28786;
        this.field_3850 *= slowFactor * this.field_28786;
        this.field_3847 = this.field_3840.method_39332(1, 10);

        ThreadLocalRandom random = ThreadLocalRandom.current();
        this.field_17867 = 0.5f * random.nextFloat();
        this.field_62634 *= random.nextFloat(0.5f, 1.0f);
    }

    @Override
    public int method_3068(float tickDelta) {
        int brightness = super.method_3068(tickDelta);
        int red = brightness >> 16 & 0xFF;
        return 0x0000F0 | red << 16;
    }

    @Override
    protected class_11941 method_74255() {
        return class_3940.class_11941.field_62640;
    }

    @Environment(EnvType.CLIENT)
    public static class Factory implements class_707<HeatDrainParticleEffect> {
        private final class_4002 spriteProvider;

        public Factory(class_4002 spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        @Override
        public @Nullable class_703 createParticle(
                HeatDrainParticleEffect parameters,
                class_638 world,
                double x, double y, double z,
                double velocityX, double velocityY, double velocityZ,
                class_5819 random
        ) {
            return new HeatDrainParticle(
                    world,
                    x, y, z,
                    velocityX, velocityY, velocityZ,
                    this.spriteProvider,
                    parameters.destination()
            );
        }
    }
}
