package com.github.thedeathlycow.frostiful.client.particle;

import com.github.thedeathlycow.frostiful.particle.WindParticleEffect;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11944;
import net.minecraft.class_156;
import net.minecraft.class_3532;
import net.minecraft.class_3940;
import net.minecraft.class_4002;
import net.minecraft.class_4184;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.client.particle.*;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@Environment(EnvType.CLIENT)
public class WindParticle extends class_3940 {
    private static final Vector3f FROM = class_156.method_654(new Vector3f(0.5F, 0.5F, 0.5F), Vector3f::normalize);
    private static final Vector3f TO = new Vector3f(-1.0F, -1.0F, 0.0F);

    private final class_4002 spriteProvider;

    private static final Quaternionf FRONT_ROTATION = new Quaternionf().rotationX(-class_3532.field_29844);
    private static final Quaternionf BACK_ROTATION = new Quaternionf().rotationYXZ(-class_3532.field_29844, class_3532.field_29844, 0.0f);

    protected WindParticle(class_638 clientWorld, double x, double y, double z, class_4002 spriteProvider) {
        super(clientWorld, x, y, z, spriteProvider.method_74304());
        this.spriteProvider = spriteProvider;
        this.field_3852 *= 2;
        this.field_17867 *= 3;
    }

    @Override
    public void method_3070() {
        super.method_3070();
        this.method_74306(this.spriteProvider);
    }

    @Override
    public void method_3074(class_11944 submittable, class_4184 camera, float tickProgress) {
        // flip so that both faces are rendered in the same direction in the absolute position of the world
        this.field_17867 *= -1;
        this.method_60373(submittable, camera, FRONT_ROTATION, tickProgress);

        // flip back to normal
        this.field_17867 *= -1;
        this.method_60373(submittable, camera, BACK_ROTATION, tickProgress);
    }

    @Override
    protected class_11941 method_74255() {
        return class_3940.class_11941.field_62640;
    }

    @Environment(EnvType.CLIENT)
    public static class Factory implements class_707<WindParticleEffect> {
        private final class_4002 spriteProvider;

        public Factory(class_4002 spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        @Override
        @Nullable
        public class_703 createParticle(
                WindParticleEffect parameters,
                class_638 world,
                double x, double y, double z,
                double velocityX, double velocityY, double velocityZ,
                class_5819 random
        ) {
            return new WindParticle(world, x, y, z, this.spriteProvider);
        }
    }
}
