package com.github.thedeathlycow.frostiful.client.registry;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.client.render.model.*;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.minecraft.class_5601;
import net.minecraft.class_575;

@Environment(EnvType.CLIENT)
public class FEntityModelLayers {

    public static final class_5601 FROST_WAND = new class_5601(Frostiful.id("frost_wand"), "main");
    public static final class_5601 FROSTOLOGER = new class_5601(Frostiful.id("frostologer"), "main");
    public static final class_5601 FROSTOLOGER_CAPE = new class_5601(Frostiful.id("frostologer"), "cape");
    public static final class_5601 CHILLAGER = new class_5601(Frostiful.id("chillager"), "main");

    public static final class_5601 BITER = new class_5601(Frostiful.id("biter"), "main");

    public static final class_5601 ICE_SKATES = new class_5601(Frostiful.id("ice_skates"), "main");
    public static final class_5601 ICE_SKATES_BABY = new class_5601(Frostiful.id("ice_skates_baby"), "main");

    public static void initialize() {
        Frostiful.LOGGER.debug("Initialized Frostiful entity model layers");
        EntityModelLayerRegistry.registerModelLayer(FROST_WAND, FrostWandItemModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer(FROSTOLOGER, FrostologerEntityModel::method_32012);
        EntityModelLayerRegistry.registerModelLayer(FROSTOLOGER_CAPE, FrostologerCapeModel::method_32012);
        EntityModelLayerRegistry.registerModelLayer(CHILLAGER, class_575::method_32012);
        EntityModelLayerRegistry.registerModelLayer(BITER, BiterEntityModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer(ICE_SKATES, IceSkateModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer(ICE_SKATES_BABY, IceSkateModel::getBabyTexturedModelData);
    }

    private FEntityModelLayers() {

    }
}
