package com.github.thedeathlycow.frostiful.client.registry;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.client.render.entity.*;
import com.github.thedeathlycow.frostiful.client.render.feature.IceSkateFeatureRenderer;
import com.github.thedeathlycow.frostiful.registry.FEntityTypes;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.LivingEntityFeatureRendererRegistrationCallback;
import net.minecraft.class_1007;
import net.minecraft.class_5619;
import net.minecraft.class_6344;
import net.minecraft.class_877;
import net.minecraft.class_908;
import net.minecraft.class_909;
import net.minecraft.class_953;
import net.minecraft.client.render.entity.*;

@Environment(EnvType.CLIENT)
public class FEntityRenderers {

    public static void initialize() {
        Frostiful.LOGGER.debug("Initialized Frostiful entity renderers");
        class_5619.method_32173(FEntityTypes.GLACIAL_ARROW, GlacialArrowEntityRenderer::new);
        class_5619.method_32173(FEntityTypes.FROST_SPELL, FrostSpellEntityRenderer::new);
        class_5619.method_32173(FEntityTypes.FROSTOLOGER, FrostologerEntityRenderer::new);
        class_5619.method_32173(FEntityTypes.CHILLAGER, ChillagerEntityRenderer::new);
        class_5619.method_32173(FEntityTypes.BITER, BiterEntityRenderer::new);
        class_5619.method_32173(FEntityTypes.PACKED_SNOWBALL, class_953::new);
        class_5619.method_32173(FEntityTypes.THROWN_ICICLE, ThrownIcicleEntityRenderer::new);
        class_5619.method_32173(FEntityTypes.FREEZING_WIND, class_6344::new);

        LivingEntityFeatureRendererRegistrationCallback.EVENT.register(
                (entityType, entityRenderer, registrationHelper, context) -> {
                    if (entityRenderer instanceof class_909<?, ?, ?> bipedEntityRenderer) {
                        registrationHelper.register(
                                new IceSkateFeatureRenderer<>(
                                        bipedEntityRenderer,
                                        context.method_32170()
                                )
                        );
                    } else if (entityRenderer instanceof class_1007 playerEntityRenderer) {
                        registrationHelper.register(
                                new IceSkateFeatureRenderer<>(
                                        playerEntityRenderer,
                                        context.method_32170()
                                )
                        );
                    } else if (entityRenderer instanceof class_877 armorStandEntityRenderer) {
                        registrationHelper.register(
                                new IceSkateFeatureRenderer<>(
                                        armorStandEntityRenderer,
                                        context.method_32170()
                                )
                        );
                    } else if (entityRenderer instanceof class_908 giantEntityRenderer) {
                        registrationHelper.register(
                                new IceSkateFeatureRenderer<>(
                                        giantEntityRenderer,
                                        context.method_32170()
                                )
                        );
                    }
                }
        );
    }

    private FEntityRenderers() {

    }
}
