package com.github.thedeathlycow.frostiful.client.render.entity;

import com.github.thedeathlycow.frostiful.client.registry.FEntityModelLayers;
import com.github.thedeathlycow.frostiful.client.render.model.FrostWandItemModel;
import com.mojang.serialization.MapCodec;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10508;
import net.minecraft.class_10515;
import net.minecraft.class_11659;
import net.minecraft.class_4587;
import net.minecraft.class_811;
import org.joml.Vector3f;

import java.util.Set;

@Environment(EnvType.CLIENT)
public class FrostWandItemRenderer implements class_10508 {
    // packed lightmap coordinates are (block << 4) | (sky << 20)
    private static final int FULL_BRIGHTNESS = (15 << 4) | (15 << 20);

    private final FrostWandItemModel model;

    public FrostWandItemRenderer(FrostWandItemModel model) {
        this.model = model;
    }

    @Override
    public void method_72175(Set<Vector3f> vertices) {
        var matrixStack = new class_4587();
        matrixStack.method_22905(1.0F, -1.0F, -1.0F);
        this.model.method_63512().method_72152(matrixStack, vertices);
    }

    @Override
    public void method_65699(
            class_811 displayContext,
            class_4587 matrices,
            class_11659 queue,
            int light,
            int overlay,
            boolean glint,
            int outlineColor
    ) {
        matrices.method_22903();
        matrices.method_22905(1.0F, -1.0F, -1.0F);

        queue.method_73494(
                this.model.method_63512(),
                matrices,
                this.model.method_23500(FrostWandItemModel.TEXTURE),
                FULL_BRIGHTNESS,
                overlay,
                null,
                false,
                glint,
                -1,
                null,
                outlineColor
        );

        matrices.method_22909();
    }

    @Environment(EnvType.CLIENT)
    public record Unbaked() implements class_10515.class_10516 {
        public static final MapCodec<FrostWandItemRenderer.Unbaked> CODEC = MapCodec.unit(new FrostWandItemRenderer.Unbaked());

        @Override
        public class_10515<?> method_65698(class_11695 context) {
            return new FrostWandItemRenderer(
                    new FrostWandItemModel(context.comp_3391().method_32072(FEntityModelLayers.FROST_WAND))
            );
        }

        @Override
        public MapCodec<FrostWandItemRenderer.Unbaked> method_65696() {
            return CODEC;
        }
    }
}
