package com.github.thedeathlycow.frostiful.client.render.entity;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.client.registry.FEntityModelLayers;
import com.github.thedeathlycow.frostiful.client.render.feature.FrostLayer;
import com.github.thedeathlycow.frostiful.client.render.feature.FrostologerCloakFeatureRenderer;
import com.github.thedeathlycow.frostiful.client.render.feature.FrostologerEyesFeatureRenderer;
import com.github.thedeathlycow.frostiful.client.render.feature.FrostologerFrostFeatureRenderer;
import com.github.thedeathlycow.frostiful.client.render.model.FrostologerEntityModel;
import com.github.thedeathlycow.frostiful.client.render.state.FrostologerEntityRenderState;
import com.github.thedeathlycow.frostiful.entity.frostologer.FrostologerEntity;
import com.github.thedeathlycow.frostiful.item.component.CapeComponent;
import com.github.thedeathlycow.frostiful.registry.FDataComponentTypes;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10426;
import net.minecraft.class_1304;
import net.minecraft.class_1543;
import net.minecraft.class_1764;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_5617;
import net.minecraft.class_927;
import net.minecraft.class_976;
import net.minecraft.class_9848;
import net.minecraft.class_989;

@Environment(EnvType.CLIENT)
public class FrostologerEntityRenderer extends class_927<FrostologerEntity, FrostologerEntityRenderState, FrostologerEntityModel<FrostologerEntityRenderState>> {


    private static final class_2960 TEXTURE = Frostiful.id("textures/entity/illager/frostologer.png");

    public FrostologerEntityRenderer(class_5617.class_5618 context) {
        super(context, new FrostologerEntityModel<>(context.method_32167(FEntityModelLayers.FROSTOLOGER)), 0.5F);

        this.method_4046(new class_976<>(this, context.method_32170(), context.method_73540()));

        this.method_4046(new class_989<>(this));
        this.method_4046(new FrostologerCloakFeatureRenderer(this, context.method_32170(), context.method_64071()));
        this.method_4046(
                new FrostologerEyesFeatureRenderer<>(
                        this,
                        Frostiful.id("textures/entity/illager/frostologer/glow.png")
                )
        );
        this.method_4046(new FrostologerFrostFeatureRenderer(this));
    }

    @Override
    public FrostologerEntityRenderState method_55269() {
        return new FrostologerEntityRenderState();
    }

    @Override
    public void updateRenderState(FrostologerEntity frostologer, FrostologerEntityRenderState state, float tickDelta) {
        super.method_62355(frostologer, state, tickDelta);
        class_10426.method_65577(frostologer, state, this.field_55298);
        state.field_53421 = frostologer.method_5765();
        state.field_53423 = frostologer.method_6068();
        state.field_53424 = frostologer.method_6990();
        state.field_53425 = state.field_53424 == class_1543.class_1544.field_7210
                ? class_1764.method_7775(frostologer.method_6030(), frostologer)
                : 0;
        state.field_53426 = frostologer.method_6048();
        state.field_53427 = frostologer.method_6055(tickDelta);
        state.field_53422 = frostologer.method_6510();


        state.usingFrostWand = frostologer.isUsingFrostWand();
        state.frostLayer = FrostLayer.fromFrostologer(frostologer);
        state.glowingEyes = frostologer.isAtMaxPower();

        float rgColorMul = 0.625f * frostologer.thermoo$getTemperatureScale() + 1f;
        state.tint = class_9848.method_61318(1f, rgColorMul, rgColorMul, 1f);

        CapeComponent cape = frostologer.method_6118(class_1304.field_6174).method_58694(FDataComponentTypes.CAPE);
        if (cape != null) {
            state.capeTexture = cape.capeAsset();
            updateCape(frostologer, state, tickDelta);
        } else {
            state.capeTexture = null;
        }
    }

    @Override
    protected int getMixColor(FrostologerEntityRenderState state) {
        return state.tint;
    }

    // i dont know what the purpose of this was so im removing it
//    @Override
//    protected void scale(FrostologerEntityRenderState state, MatrixStack matrices) {
//        float scale = 15f / 16f;
//        matrices.scale(scale, scale, scale);
//    }

    @Override
    public class_2960 getTexture(FrostologerEntityRenderState pillagerEntity) {
        return TEXTURE;
    }

    private static void updateCape(FrostologerEntity frostologer, FrostologerEntityRenderState state, float tickDelta) {
        double deltaX = class_3532.method_16436(tickDelta, frostologer.prevCapeX, frostologer.capeX) - class_3532.method_16436(tickDelta, frostologer.field_6014, frostologer.method_23317());
        double deltaY = class_3532.method_16436(tickDelta, frostologer.prevCapeY, frostologer.capeY) - class_3532.method_16436(tickDelta, frostologer.field_6036, frostologer.method_23318());
        double deltaZ = class_3532.method_16436(tickDelta, frostologer.prevCapeZ, frostologer.capeZ) - class_3532.method_16436(tickDelta, frostologer.field_5969, frostologer.method_23321());

        float bodyYaw = class_3532.method_17821(tickDelta, frostologer.field_6220, frostologer.field_6283);
        double sinYaw = class_3532.method_15374(bodyYaw * (float) (Math.PI / 180.0));
        double cosYaw = -class_3532.method_15362(bodyYaw * (float) (Math.PI / 180.0));

        state.capePitch = (float) deltaY * 10.0f;
        state.capePitch = class_3532.method_15363(state.capePitch, -6.0f, 32.0f);

        state.capeSwing = (float) (deltaX * sinYaw + deltaZ * cosYaw) * 100.0f;
        state.capeSwing = class_3532.method_15363(state.capeSwing, 0.0f, 150.0f);

        state.capeStrafe = (float) (deltaX * cosYaw - deltaZ * sinYaw) * 100.0f;
        state.capeStrafe = class_3532.method_15363(state.capeStrafe, -20.0f, 20.0f);

        if (state.field_53334) {
            state.capePitch += 25.0F;
        }

        // TODO: prevHorizontalSpeed, horizontalSpeed need to be done for the frostloger specifically now, but i dont feel like it (and it doesnt seem to have a big effect?)
//        float stride = MathHelper.lerp(tickDelta, frostologer.prevStrideDistance, frostologer.strideDistance);
//        float distanceMoved = MathHelper.lerp(tickDelta, frostologer.prevHorizontalSpeed, frostologer.horizontalSpeed);
//        state.capePitch += MathHelper.sin(distanceMoved * 6.0f) * 32.0f * stride;
    }
}
