package com.github.thedeathlycow.frostiful.compat;

import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import org.jetbrains.annotations.Nullable;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_3545;
import net.minecraft.class_9331;

public final class TrinketsIntegration {
    public static <T> List<class_3545<SlotReference, class_1799>> getEquippedTrinket(class_1309 entity, class_9331<T> type) {
        return TrinketsApi.getTrinketComponent(entity)
                .map(trinketComponent -> trinketComponent.getEquipped(s -> s.method_57826(type)))
                .orElse(Collections.emptyList());
    }

    @Nullable
    public static <T> T getComponentInCapeSlot(class_1309 entity, class_9331<T> type) {
        return TrinketsApi.getTrinketComponent(entity)
                .map(trinket -> getFirstInCapeOrNull(trinket, type))
                .orElse(null);
    }

    @Nullable
    private static <T> T getFirstInCapeOrNull(TrinketComponent trinket, class_9331<T> type) {
        Map<String, TrinketInventory> chest = trinket.getInventory().get("chest");
        if (chest == null) {
            return null;
        }

        TrinketInventory cape = chest.get("cape");
        if (cape == null) {
            return null;
        }

        for (int i = 0; i < cape.method_5439(); i++) {
            T component = cape.method_5438(i).method_58694(type);
            if (component != null) {
                return component;
            }
        }

        return null;
    }

    private TrinketsIntegration() {

    }
}