package com.github.thedeathlycow.frostiful.entity;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.registry.FComponents;
import com.github.thedeathlycow.frostiful.registry.FEntityAttributes;
import com.github.thedeathlycow.frostiful.registry.FSoundEvents;
import com.github.thedeathlycow.frostiful.registry.FStatusEffects;
import com.github.thedeathlycow.thermoo.api.ThermooAttributes;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1405;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3763;
import net.minecraft.class_4051;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_6024;
import net.minecraft.class_7094;
import net.minecraft.entity.*;
import net.minecraft.entity.ai.goal.*;
import org.jetbrains.annotations.Nullable;

import java.util.EnumSet;

public class BiterEntity extends class_1588 {

    private static final class_2940<Byte> ICE_GOLEM_FLAGS = class_2945.method_12791(BiterEntity.class, class_2943.field_13319);

    private static final int IS_CHARGING_FLAG_MASK = 0x1;

    public static final int ATTACK_TIME = 10;

    @Nullable
    class_1308 owner;

    private int attackTicks = 0;

    public final class_7094 bitingAnimation = new class_7094();

    public BiterEntity(class_1299<? extends BiterEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    public static class_5132.class_5133 createBiterAttributes() {
        return class_1588.method_26918()
                .method_26868(class_5134.field_23716, 14.0)
                .method_26868(class_5134.field_23721, 7.0)
                .method_26868(ThermooAttributes.MIN_TEMPERATURE, 45.0)
                .method_26868(FEntityAttributes.ICE_BREAK_DAMAGE, 5.0);
    }

    @Override
    public void method_6007() {
        super.method_6007();

        if (this.method_5805()) {
            if (this.attackTicks > 0) {
                this.attackTicks--;
            }
        }
    }

    @Override
    public boolean method_6121(class_3218 world, class_1297 target) {
        this.attackTicks = ATTACK_TIME;
        world.method_8421(this, class_6024.field_30029);
        this.method_59928();
        if (target instanceof class_1309 livingTarget && FComponents.FROST_WAND_ROOT_COMPONENT.get(livingTarget).isRooted()) {
            int maxAmplifier = Frostiful.getConfig().combatConfig.getBiterFrostBiteMaxAmplifier() + 1;

            livingTarget.method_37222(
                    new class_1293(
                            FStatusEffects.FROST_BITE,
                            20 * 15,
                            this.field_5974.method_43048(maxAmplifier)
                    ),
                    this
            );
        }
        return super.method_6121(world, target);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(ICE_GOLEM_FLAGS, (byte) 0);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, new class_1347(this));
        this.field_6201.method_6277(4, new class_1366(this, 1.0, true));
        this.field_6201.method_6277(9, new class_1361(this, class_1657.class, 3.0F, 1.0F));
        this.field_6201.method_6277(10, new class_1361(this, class_1308.class, 8.0F));

        this.field_6185.method_6277(1, new class_1399(this, class_3763.class).method_6318());
        this.field_6185.method_6277(2, new TrackOwnerTargetGoal());
        this.field_6185.method_6277(3, new class_1400<>(this, class_1657.class, true));
    }

    @Nullable
    public class_1308 getOwner() {
        return owner;
    }

    public void setOwner(@Nullable class_1308 owner) {
        this.owner = owner;
    }

    public boolean isCharging() {
        return this.checkFlag(IS_CHARGING_FLAG_MASK);
    }

    public void setCharging(boolean charging) {
        this.setIceGolemFlag(IS_CHARGING_FLAG_MASK, charging);
    }

    public int getAttackTicks() {
        return attackTicks;
    }

    @Override
    public void method_5711(byte status) {
        if (status == class_6024.field_30029) {
            this.attackTicks = ATTACK_TIME;
            this.method_59928();
            this.bitingAnimation.method_41322(this.field_6012);
        } else {
            super.method_5711(status);
        }
    }

    @Override
    public void method_5652(class_11372 writeView) {
        super.method_5652(writeView);
        writeView.method_71465("AttackTicks", this.attackTicks);
    }

    @Override
    public void method_5749(class_11368 readView) {
        super.method_5749(readView);
        this.attackTicks = readView.method_71424("AttackTicks", 0);
    }

    @Override
    protected class_3414 method_5994() {
        return FSoundEvents.ENTITY_BITER_AMBIENT;
    }

    @Override
    protected class_3414 method_6002() {
        return FSoundEvents.ENTITY_BITER_DEATH;
    }

    @Override
    protected class_3414 method_6011(class_1282 source) {
        return FSoundEvents.ENTITY_BITER_HURT;
    }

    private boolean checkFlag(int mask) {
        int i = this.field_6011.method_12789(ICE_GOLEM_FLAGS);
        return (i & mask) != 0;
    }

    private void setIceGolemFlag(int mask, boolean value) {
        int flags = this.field_6011.method_12789(ICE_GOLEM_FLAGS);
        if (value) {
            flags |= mask;
        } else {
            flags &= ~mask;
        }

        this.field_6011.method_12778(ICE_GOLEM_FLAGS, (byte) (flags & 0xff));
    }

    public void method_59928() {
        this.method_5783(FSoundEvents.ENTITY_BITER_BITE, 1.0F, 1.0F);
    }

    private class ChargeTargetGoal extends class_1352 {
        public ChargeTargetGoal() {
            this.method_6265(EnumSet.of(class_4134.field_18405));
        }

        @Override
        public boolean method_6264() {
            class_1309 target = BiterEntity.this.method_5968();

            boolean hasTarget = target != null
                    && target.method_5805()
                    && !BiterEntity.this.method_5962().method_6241()
                    && BiterEntity.this.field_5974.method_43048(class_1352.method_38848(7)) == 0;

            if (hasTarget) {
                return BiterEntity.this.method_5858(target) > 4.0;
            } else {
                return false;
            }
        }

        @Override
        public boolean method_6266() {
            return BiterEntity.this.method_5962().method_6241()
                    && BiterEntity.this.isCharging()
                    && BiterEntity.this.method_5968() != null
                    && BiterEntity.this.method_5968().method_5805();
        }

        @Override
        public void method_6269() {
            class_1309 target = BiterEntity.this.method_5968();
            if (target != null) {
                class_243 targetPos = target.method_33571();
                BiterEntity.this.field_6207.method_6239(targetPos.field_1352, targetPos.field_1351, targetPos.field_1350, 1.0);
            }

            BiterEntity.this.setCharging(true);
            BiterEntity.this.method_5783(class_3417.field_14898, 1.0f, 1.0f);
        }

        @Override
        public void method_6270() {
            BiterEntity.this.setCharging(false);
        }

        @Override
        public boolean method_38846() {
            return true;
        }

        @Override
        public void method_6268() {
            class_1309 target = BiterEntity.this.method_5968();
            if (target != null) {

                double distanceToTarget = BiterEntity.this.method_5858(target);
                if (distanceToTarget < 1.5) {
                    BiterEntity.this.method_6121(method_64451(target), target);
                    BiterEntity.this.setCharging(false);
                } else if (distanceToTarget < 9.0) {
                    class_243 targetPos = target.method_33571();
                    BiterEntity.this.field_6207.method_6239(targetPos.field_1352, targetPos.field_1351, targetPos.field_1350, 1.0);
                }
            }
        }
    }

    public class TrackOwnerTargetGoal extends class_1405 {
        private final class_4051 targetPredicate = class_4051.method_36626().method_36627().method_18424();

        public TrackOwnerTargetGoal() {
            super(BiterEntity.this, false);
        }

        public boolean method_6264() {
            return BiterEntity.this.owner != null
                    && BiterEntity.this.owner.method_5968() != null
                    && this.method_6328(BiterEntity.this.owner.method_5968(), this.targetPredicate);
        }

        public void method_6269() {
            if (BiterEntity.this.owner != null) {
                BiterEntity.this.method_5980(BiterEntity.this.owner.method_5968());
            }
            super.method_6269();
        }
    }
}
