package com.github.thedeathlycow.frostiful.entity;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.config.FrostifulConfig;
import com.github.thedeathlycow.frostiful.registry.FEntityTypes;
import com.github.thedeathlycow.frostiful.registry.FItems;
import com.github.thedeathlycow.frostiful.registry.FSoundEvents;
import com.github.thedeathlycow.thermoo.api.ThermooAttributes;
import net.minecraft.class_10179;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1538;
import net.minecraft.class_1604;
import net.minecraft.class_1799;
import net.minecraft.class_1811;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_5132;
import net.minecraft.class_8103;

public class ChillagerEntity extends class_1604 {
    public ChillagerEntity(class_1299<? extends ChillagerEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    public static class_5132.class_5133 createChillagerAttributes() {
        return class_1604.method_26919()
                .method_26868(ThermooAttributes.MIN_TEMPERATURE, 45.0)
                .method_26868(ThermooAttributes.FROST_RESISTANCE, 10.0);
    }

    @Override
    public boolean method_64397(class_3218 world, class_1282 source, float amount) {
        if (source.method_48789(class_8103.field_42246)) {
            FrostifulConfig config = Frostiful.getConfig();
            amount *= config.combatConfig.getChillagerFireDamageMultiplier();
        }

        return super.method_64397(world, source, amount);
    }

    @Override
    public void method_5800(class_3218 world, class_1538 lightning) {
        if (world.method_8407() != class_1267.field_5801) {
            Frostiful.LOGGER.info("Chillager {} was struck by lightning {}.", this, lightning);
            this.method_29243(
                    FEntityTypes.FROSTOLOGER,
                    class_10179.method_63607(this, false, true) ,
                    frostologer -> {
                        frostologer.method_5964(world.field_9229, world.method_8404(frostologer.method_24515()));
                    }
            );
        } else {
            super.method_5800(world, lightning);
        }
    }

    @Override
    public class_1799 method_18808(class_1799 stack) {
        if (stack.method_7909() instanceof class_1811 rangedWeaponItem) {
            class_1799 itemStack = class_1811.method_18815(
                    this,
                    rangedWeaponItem.method_20310()
            );

            return itemStack.method_7960() ? new class_1799(FItems.GLACIAL_ARROW) : itemStack;
        } else {
            return class_1799.field_8037;
        }
    }

    @Override
    protected class_3414 method_5994() {
        return FSoundEvents.ENTITY_CHILLAGER_AMBIENT;
    }

    @Override
    protected class_3414 method_6002() {
        return FSoundEvents.ENTITY_CHILLAGER_DEATH;
    }

    @Override
    protected class_3414 method_6011(class_1282 source) {
        return FSoundEvents.ENTITY_CHILLAGER_HURT;
    }

    @Override
    public class_3414 method_20033() {
        return FSoundEvents.ENTITY_CHILLAGER_CELEBRATE;
    }

}
