package com.github.thedeathlycow.frostiful.entity;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.thermoo.api.temperature.HeatingModes;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;

public class FreezingWindEntity extends WindEntity {

    private int frost;

    public FreezingWindEntity(class_1299<? extends FreezingWindEntity> type, class_1937 world) {
        super(type, world);
        this.frost = Frostiful.getConfig().freezingConfig.getFreezingWindFrost();
    }

    @Override
    public void onEntityCollision(class_1309 entity) {
        super.onEntityCollision(entity);
        freezeEntity(entity, this.frost);
    }

    public static void freezeEntity(class_1309 entity, int frost) {
        if (entity.method_5864() == class_1299.field_6097) {
            entity.thermoo$addTemperature(-frost, HeatingModes.ACTIVE);
        }
    }

    protected class_2394 getDustParticle() {
        return class_2398.field_28013;
    }

    @Override
    protected void method_5749(class_11368 readView) {
        super.method_5749(readView);
        this.frost = readView.method_71424("Frost", Frostiful.getConfig().freezingConfig.getFreezingWindFrost());
    }

    @Override
    protected void method_5652(class_11372 writeView) {
        super.method_5652(writeView);

        writeView.method_71465("Frost", this.frost);
    }
}
