package com.github.thedeathlycow.frostiful.entity;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.config.group.IcicleConfigGroup;
import com.github.thedeathlycow.frostiful.registry.FEntityTypes;
import com.github.thedeathlycow.frostiful.registry.FItems;
import com.github.thedeathlycow.frostiful.registry.FSoundEvents;
import com.github.thedeathlycow.thermoo.api.temperature.HeatingModes;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2398;
import net.minecraft.class_3414;
import net.minecraft.class_3483;
import net.minecraft.class_3966;

public class ThrownIcicleEntity extends class_1665 {

    public ThrownIcicleEntity(class_1299<? extends ThrownIcicleEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    public ThrownIcicleEntity(class_1937 world, double x, double y, double z, class_1799 stack) {
        super(FEntityTypes.THROWN_ICICLE, x, y, z, world, stack, stack);
    }

    public ThrownIcicleEntity(class_1937 world, class_1309 owner, class_1799 stack) {
        super(FEntityTypes.THROWN_ICICLE, owner, world, stack, null);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        class_1937 world = method_73183();
        if (world.method_8608() && !this.method_65059()) {
            world.method_8406(class_2398.field_28013, this.method_23317(), this.method_23318(), this.method_23321(), 0.0D, 0.0D, 0.0D);
        }
    }

    @Override
    protected void method_7454(class_3966 entityHitResult) {

        if (entityHitResult.method_17782().method_5864() == FEntityTypes.FROSTOLOGER) {
            return;
        }

        IcicleConfigGroup config = Frostiful.getConfig().icicleConfig;

        float damage = entityHitResult.method_17782().method_5864().method_20210(class_3483.field_29826)
                ? config.getThrownIcicleExtraDamage()
                : config.getThrownIcicleDamage();
        this.method_7438(damage);

        super.method_7454(entityHitResult);
    }

    @Override
    protected void method_7450(class_1309 target) {
        super.method_7450(target);
        IcicleConfigGroup config = Frostiful.getConfig().icicleConfig;
        int freezeAmount = config.getThrownIcicleFreezeAmount();

        target.thermoo$addTemperature(-freezeAmount, HeatingModes.ACTIVE);
    }

    @Override
    protected class_3414 method_7440() {
        return FSoundEvents.ENTITY_THROWN_ICICLE_HIT;
    }

    @Override
    protected class_1799 method_57314() {
        return new class_1799(FItems.ICICLE);
    }
}
