package com.github.thedeathlycow.frostiful.entity.ai.goal;

import com.github.thedeathlycow.frostiful.entity.component.BrushableComponent;
import com.github.thedeathlycow.frostiful.registry.FComponents;
import com.github.thedeathlycow.frostiful.util.FLootHelper;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_3218;
import net.minecraft.class_4051;
import net.minecraft.class_52;
import net.minecraft.class_5321;

public class PlayFightGoal<T extends class_1314> extends class_1352 {

    private static final class_4051 VALID_PLAYFIGHT_PREDICATE = class_4051.method_36625()
            .method_18418(8.0D)
            .method_36627();

    private static final int MAX_FIGHT_TIME = 30;

    protected final T mob;
    private final Class<T> type;
    @Nullable
    protected T target;
    @Nullable
    protected final class_5321<class_52> furLootTable;
    private final float adultChance;
    private final float babyChance;
    private int timer;
    private boolean droppedFur = false;

    public PlayFightGoal(T mob, Class<T> type, float adultChance, float babyChance, @Nullable class_5321<class_52> furLootTable) {
        this.mob = mob;
        this.type = type;
        this.adultChance = adultChance;
        this.babyChance = babyChance;
        this.target = null;
        this.timer = 0;
        this.furLootTable = furLootTable;
    }

    @Override
    public boolean method_6264() {

        float chance = this.mob.method_6109() ? this.babyChance : this.adultChance;

        if (this.mob.method_59922().method_43057() < chance) {
            this.target = this.findTarget();
            return this.target != null;
        } else {
            return false;
        }
    }

    @Override
    public boolean method_6266() {
        return this.target != null
                && this.target.method_5805()
                && this.timer < MAX_FIGHT_TIME;
    }

    @Override
    public void method_6270() {
        this.target = null;
        this.timer = 0;
        this.droppedFur = false;
    }

    @Override
    public void method_6268() {
        if (this.target == null) {
            return;
        }

        this.mob.method_5988().method_6226(this.target, 30.0F, 30.0F);
        this.mob.method_5942().method_6335(this.target, 1.0f);

        this.timer++;
        if (this.timer >= this.method_38847(MAX_FIGHT_TIME) && this.mob.method_5858(this.target) < 9.0D) {
            this.playFight();
        }
    }

    protected void playFight() {
        if (target != null) {
            this.mob.method_6104(class_1268.field_5808);
            this.target.method_5951(this.mob, 30f, 30f);
            this.target.method_6104(class_1268.field_5808);

            if (this.timer == this.method_38847(MAX_FIGHT_TIME)) {
                class_3218 world = method_64451(this.mob);
                this.mob.method_64397(world, this.mob.method_48923().method_48830(), 0.0f);
                this.target.method_64397(world, this.target.method_48923().method_48830(), 0.0f);
            }

            this.dropFur();
        }

    }

    protected void dropFur() {
        if (this.target == null || this.droppedFur) {
            return;
        }

        BrushableComponent brushableComponent = FComponents.BRUSHABLE_COMPONENT.getNullable(this.mob);
        if (brushableComponent == null || !brushableComponent.wasBrushed()) {
            FLootHelper.dropLootFromEntity(this.mob, this.furLootTable);
        }

        this.droppedFur = true;
    }

    /**
     * Finds the closest possible target to playfight with
     *
     * @return Returns a nullable pointer to the nearest path aware entity that this.mob can play
     * fight with.
     */
    @Nullable
    private T findTarget() {
        class_3218 world = method_64451(this.mob);
        List<? extends T> candidates = world.method_64392(this.type, VALID_PLAYFIGHT_PREDICATE, this.mob, this.mob.method_5829().method_1014(8.0));
        double closestEntityDistance = Double.POSITIVE_INFINITY;

        T closestTargetSoFar = null;
        for (T candidate : candidates) {
            double distance = this.mob.method_5858(candidate);
            if (this.canPlayFightWith(candidate) && distance < closestEntityDistance) {
                closestTargetSoFar = candidate;
                closestEntityDistance = distance;
            }
        }
        return closestTargetSoFar;
    }

    private boolean canPlayFightWith(class_1314 candidate) {
        return candidate.method_5864() == this.mob.method_5864() && this.mob.method_6109() == candidate.method_6109();
    }
}


