package com.github.thedeathlycow.frostiful.entity.component;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.registry.FComponents;
import com.github.thedeathlycow.thermoo.api.ThermooAttributes;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import org.ladysnake.cca.api.v3.component.Component;
import org.ladysnake.cca.api.v3.component.tick.ServerTickingComponent;

public class SnowAccumulationComponent implements Component, ServerTickingComponent {
    private static final class_1322 SOAKED_MODIFIER = new class_1322(
            Frostiful.id("soaked_cold_vulnerability"),
            -1,
            class_1322.class_1323.field_6331
    );

    private static final String KEY = "snow_accumulation";

    private final class_1309 provider;

    private int snowAccumulation = 0;

    private boolean appliedSoakedModifiers = false;

    public SnowAccumulationComponent(class_1309 provider) {
        this.provider = provider;
    }

    public static SnowAccumulationComponent get(class_1309 provider) {
        return FComponents.SNOW_ACCUMULATION.get(provider);
    }

    @Override
    public void serverTick() {
        if (this.isBeingSnowedOn()) {
            this.addSnowAccumulation();
        } else {
            this.meltSnowAccumulation();
        }

        if (Frostiful.getConfig().environmentConfig.applyEnvironmentPenaltyWhenWet()) {
            this.applySoakedEnvironmentFrostResistancePenalty();
        }
    }

    @Override
    public void readData(class_11368 readView) {
        this.snowAccumulation = readView.method_71424(KEY, 0);
    }

    @Override
    public void writeData(class_11372 writeView) {
        if (this.snowAccumulation > 0) {
            writeView.method_71465(KEY, this.snowAccumulation);
        }
    }

    public boolean isBeingSnowedOn() {
        class_1937 world = this.provider.method_73183();
        class_2338 pos = this.provider.method_24515();
        return hasSnow(world, pos)
                || hasSnow(world, class_2338.method_49637(pos.method_10263(), this.provider.method_5829().field_1325, pos.method_10260()));
    }

    public static boolean hasSnow(class_1937 world, class_2338 pos) {
        if (!world.method_8419()) {
            return false;
        } else if (!world.method_8311(pos)) {
            return false;
        } else if (world.method_8598(class_2902.class_2903.field_13197, pos).method_10264() > pos.method_10264()) {
            return false;
        } else {
            class_1959 biome = world.method_23753(pos).comp_349();
            return biome.method_48162(pos, world.method_8615()) == class_1959.class_1963.field_9383;
        }
    }

    public void meltSnowAccumulation() {
        if (this.snowAccumulation > 0) {
            this.snowAccumulation--;
            this.provider.thermoo$addWetTicks(2);
        }
    }

    private void addSnowAccumulation() {
        if (this.snowAccumulation < Frostiful.getConfig().environmentConfig.getMaxSnowAccumulationTicks()) {
            this.snowAccumulation++;
        }
    }

    private void applySoakedEnvironmentFrostResistancePenalty() {
        // this probably doesnt belong in this component but oh well i dont feel like making another one
        boolean wet = provider.thermoo$isWet();
        if (wet && !this.appliedSoakedModifiers && !provider.thermoo$ignoresFrigidWater()) {
            var envFrostResistance = provider.method_5996(ThermooAttributes.ENVIRONMENT_FROST_RESISTANCE);

            if (envFrostResistance != null) {
                envFrostResistance.method_26835(SOAKED_MODIFIER);
                this.appliedSoakedModifiers = true;
                Frostiful.LOGGER.debug("Applied soaked env frost resistance penalty");
            }
        } else if (!wet && this.appliedSoakedModifiers) {
            var envFrostResistance = provider.method_5996(ThermooAttributes.ENVIRONMENT_FROST_RESISTANCE);

            if (envFrostResistance != null) {
                envFrostResistance.method_6202(SOAKED_MODIFIER);
                this.appliedSoakedModifiers = false;
                Frostiful.LOGGER.debug("Removed soaked env frost resistance penalty");
            }
        }
    }
}