package com.github.thedeathlycow.frostiful.entity.frostologer;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.registry.FItems;
import com.github.thedeathlycow.frostiful.registry.FSoundEvents;
import net.minecraft.class_1268;
import net.minecraft.class_1381;

class FrostWandCastGoal extends class_1381 {

    private final FrostologerEntity frostologerEntity;

    public FrostWandCastGoal(FrostologerEntity frostologer, double mobSpeed, int intervalTicks, float maxShootRange) {
        super(frostologer, mobSpeed, intervalTicks, maxShootRange);
        this.frostologerEntity = frostologer;
    }

    @Override
    public boolean method_6264() {
        return super.method_6264()
                && frostologerEntity.hasTarget()
                && !frostologerEntity.isTargetRooted()
                && frostologerEntity.method_6047().method_31574(FItems.FROST_WAND);
    }

    @Override
    public void method_6269() {
        super.method_6269();
        frostologerEntity.method_19540(true);
        frostologerEntity.method_6019(class_1268.field_5808);
        this.startUsingFrostWand();
    }

    @Override
    public void method_6270() {
        super.method_6270();
        frostologerEntity.method_19540(false);
        frostologerEntity.method_6021();
        this.stopUsingFrostWand();
        if (frostologerEntity.isTargetRooted()) {
            int cooling = -Frostiful.getConfig().combatConfig.getFrostologerCoolingFromFrostWandHit();
            frostologerEntity.thermoo$addTemperature(cooling);
        }
    }

    private void startUsingFrostWand() {
        frostologerEntity.method_5783(
                FSoundEvents.ITEM_FROST_WAND_PREPARE_CAST,
                1.0f, 1.0f
        );
        frostologerEntity.method_5841().method_12778(FrostologerEntity.IS_USING_FROST_WAND, true);
    }

    private void stopUsingFrostWand() {
        frostologerEntity.method_5841().method_12778(FrostologerEntity.IS_USING_FROST_WAND, false);
    }
}