package com.github.thedeathlycow.frostiful.item.component;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.compat.FrostifulIntegrations;
import com.github.thedeathlycow.frostiful.compat.TrinketsIntegration;
import com.github.thedeathlycow.frostiful.registry.FDataComponentTypes;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_12079;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public record CapeComponent(
        class_12079.class_10726 capeAsset,
        boolean overrideAccountCape
) {
    public static final CapeComponent FROSTOLOGY_CLOAK = new CapeComponent(
            new class_12079.class_10726(Frostiful.id("entity/frostology_cloak")),
            true
    );

    public static final Codec<CapeComponent> CODEC = RecordCodecBuilder.create(
            instance -> instance.group(
                    class_12079.class_10726.field_56393
                            .fieldOf("cape_asset")
                            .forGetter(CapeComponent::capeAsset),
                    Codec.BOOL
                            .optionalFieldOf("override_account_cape", true)
                            .forGetter(CapeComponent::overrideAccountCape)
            ).apply(instance, CapeComponent::new)
    );

    public static final class_9139<class_9129, CapeComponent> PACKET_CODEC = class_9139.method_56435(
            class_12079.class_10726.field_56395,
            CapeComponent::capeAsset,
            class_9135.field_48547,
            CapeComponent::overrideAccountCape,
            CapeComponent::new
    );

    @Nullable
    public static CapeComponent getCapeOrChest(class_1309 entity) {
        if (FrostifulIntegrations.isModLoaded(FrostifulIntegrations.TRINKETS_ID)) {
            CapeComponent cape = TrinketsIntegration.getComponentInCapeSlot(entity, FDataComponentTypes.CAPE);
            if (cape != null) {
                return cape;
            }
        }

        return entity.method_6118(class_1304.field_6174).method_58694(FDataComponentTypes.CAPE);
    }
}
