package com.github.thedeathlycow.frostiful.mixins.world;

import com.github.thedeathlycow.frostiful.survival.wind.WindManager;
import net.minecraft.class_10209;
import net.minecraft.class_1937;
import net.minecraft.class_2818;
import net.minecraft.class_2874;
import net.minecraft.class_3218;
import net.minecraft.class_3695;
import net.minecraft.class_5269;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_3218.class)
public abstract class WindSpawningMixin extends class_1937 {
    protected WindSpawningMixin(class_5269 properties, class_5321<class_1937> registryRef, class_5455 registryManager, class_6880<class_2874> dimensionEntry, boolean isClient, boolean debugWorld, long seed, int maxChainedNeighborUpdates) {
        super(properties, registryRef, registryManager, dimensionEntry, isClient, debugWorld, seed, maxChainedNeighborUpdates);
    }

    @Inject(
            method = "tickChunk",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/util/profiler/Profiler;push(Ljava/lang/String;)V",
                    shift = At.Shift.AFTER,
                    ordinal = 0
            )
    )
    private void tickWindSpawn(class_2818 chunk, int randomTickSpeed, CallbackInfo ci) {
        class_3695 profiler = class_10209.method_64146();
        profiler.method_15396("frostiful.freezingWindTick");
        WindManager.INSTANCE.trySpawnFreezingWind(this, chunk);
        profiler.method_15407();
    }

}
