package com.github.thedeathlycow.frostiful.mixins.world.spawner;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.server.world.ChillagerPatrolSpawner;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3769;
import net.minecraft.class_5819;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_3769.class)
public class PatrolSpawnerMixin {


    @Inject(
            method = "spawnPillager",
            at = @At("HEAD"),
            cancellable = true
    )
    private void spawnChillagerInColdBiomes(class_3218 world, class_2338 pos, class_5819 random, boolean captain, CallbackInfoReturnable<Boolean> cir) {
        if (!Frostiful.getConfig().combatConfig.doChillagerPatrols()) {
            return;
        }

        var biome = world.method_23753(pos).comp_349();

        if (biome.method_33599(pos, world.method_8615())) {
            cir.setReturnValue(ChillagerPatrolSpawner.spawnChillagerPatrol(world, pos, random, captain));
        }
    }

}
