package com.github.thedeathlycow.frostiful.registry;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.item.*;
import com.github.thedeathlycow.frostiful.item.attribute.FrostResistanceComponent;
import com.github.thedeathlycow.frostiful.item.attribute.ResistanceComponentBuilder;
import com.github.thedeathlycow.frostiful.item.cloak.FrostologyCloakItemComponents;
import com.github.thedeathlycow.frostiful.item.component.CapeComponent;
import com.github.thedeathlycow.frostiful.item.component.IceLikeComponent;
import com.github.thedeathlycow.frostiful.item.component.InertTooltipComponent;
import com.github.thedeathlycow.frostiful.registry.tag.FBannerPatternTags;
import com.github.thedeathlycow.frostiful.registry.tag.FItemTags;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1814;
import net.minecraft.class_1826;
import net.minecraft.class_1827;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8051;
import net.minecraft.class_8052;
import net.minecraft.class_9334;
import net.minecraft.item.*;
import java.util.function.Function;

public final class FItems {
    public static final class_1792 FUR_HELMET = register(
            "fur_helmet",
            settings -> new class_1792(
                    settings
                            .method_66332(FArmorMaterials.FUR, class_8051.field_41934)
                            .method_7895(class_8051.field_41934.method_56690(5))
                            .method_57349(FDataComponentTypes.FROST_RESISTANCE, FrostResistanceComponent.VERY_PROTECTIVE)
            )
    );
    public static final class_1792 FUR_CHESTPLATE = register(
            "fur_chestplate",
            settings -> new class_1792(
                    settings
                            .method_66332(FArmorMaterials.FUR, class_8051.field_41935)
                            .method_7895(class_8051.field_41935.method_56690(5))
                            .method_57349(FDataComponentTypes.FROST_RESISTANCE, FrostResistanceComponent.VERY_PROTECTIVE)
            )
    );
    public static final class_1792 FUR_LEGGINGS = register(
            "fur_leggings",
            settings -> new class_1792(
                    settings
                            .method_66332(FArmorMaterials.FUR, class_8051.field_41936)
                            .method_7895(class_8051.field_41936.method_56690(5))
                            .method_57349(FDataComponentTypes.FROST_RESISTANCE, FrostResistanceComponent.VERY_PROTECTIVE)
            )
    );
    public static final class_1792 FUR_BOOTS = register(
            "fur_boots",
            settings -> new class_1792(
                    settings
                            .method_66332(FArmorMaterials.FUR, class_8051.field_41937)
                            .method_7895(class_8051.field_41937.method_56690(5))
                            .method_57349(FDataComponentTypes.FROST_RESISTANCE, FrostResistanceComponent.VERY_PROTECTIVE)
            )
    );

    public static final class_1792 FUR_PADDING = register("fur_padding");

    public static final class_1792 FUR_UPGRADE_TEMPLATE = register(
            "fur_upgrade_template",
            settings -> FurSmithingUpgradeTemplate.createItem(settings.method_7894(class_1814.field_8907))
    );

    public static final class_1792 ICE_SKATE_UPGRADE_TEMPLATE = register(
            "ice_skate_upgrade_template",
            settings -> IceSkateUpgradeTemplate.createItem(settings.method_7894(class_1814.field_8907))
    );

    public static final class_1792 FROSTY_ARMOR_TRIM_SMITHING_TEMPLATE = register(
            "frosty_armor_trim_smithing_template",
            settings -> class_8052.method_48418(settings.method_7894(class_1814.field_8903))
    );

    public static final class_1792 FUR_PADDED_CHAINMAIL_HELMET = register(
            "fur_padded_chainmail_helmet",
            settings -> new class_1792(
                    settings
                            .method_66332(FArmorMaterials.FUR_LINED_CHAINMAIL, class_8051.field_41934)
                            .method_7895(class_8051.field_41934.method_56690(15))
                            .method_57349(FDataComponentTypes.FROST_RESISTANCE, FrostResistanceComponent.VERY_PROTECTIVE)
            )
    );
    public static final class_1792 FUR_PADDED_CHAINMAIL_CHESTPLATE = register(
            "fur_padded_chainmail_chestplate",
            settings -> new class_1792(
                    settings
                            .method_66332(FArmorMaterials.FUR_LINED_CHAINMAIL, class_8051.field_41935)
                            .method_7895(class_8051.field_41935.method_56690(15))
                            .method_57349(FDataComponentTypes.FROST_RESISTANCE, FrostResistanceComponent.VERY_PROTECTIVE)
            )
    );
    public static final class_1792 FUR_PADDED_CHAINMAIL_LEGGINGS = register(
            "fur_padded_chainmail_leggings",
            settings -> new class_1792(
                    settings
                            .method_66332(FArmorMaterials.FUR_LINED_CHAINMAIL, class_8051.field_41936)
                            .method_7895(class_8051.field_41936.method_56690(15))
                            .method_57349(FDataComponentTypes.FROST_RESISTANCE, FrostResistanceComponent.VERY_PROTECTIVE)
            )
    );
    public static final class_1792 FUR_PADDED_CHAINMAIL_BOOTS = register(
            "fur_padded_chainmail_boots",
            settings -> new class_1792(
                    settings
                            .method_66332(FArmorMaterials.FUR_LINED_CHAINMAIL, class_8051.field_41937)
                            .method_7895(class_8051.field_41937.method_56690(15))
                            .method_57349(FDataComponentTypes.FROST_RESISTANCE, FrostResistanceComponent.VERY_PROTECTIVE)
            )
    );

    public static final class_1792 GLACIAL_HEART = register(
            "glacial_heart",
            settings -> new class_1792(
                    settings
                            .method_7894(class_1814.field_8907)
            )
    );

    public static final class_1792 INERT_FROSTOLOGY_CLOAK = register(
            "inert_frostology_cloak",
            settings -> new class_1792(
                    settings
                            .method_57349(FDataComponentTypes.INERT_TOOLTIP, InertTooltipComponent.INSTANCE)
                            .method_57349(FDataComponentTypes.CAPE, CapeComponent.FROSTOLOGY_CLOAK)
                            .method_57349(class_9334.field_54196, FrostologyCloakItemComponents.createEquippableComponent())
                            .method_7894(class_1814.field_8907)
                            .method_7889(1)
            )
    );

    public static final class_1792 FROSTOLOGY_CLOAK = register(
            "frostology_cloak",
            settings -> new class_1792(
                    settings
                            .method_57348(FrostologyCloakItemComponents.createAttributeModifiers())
                            .method_57349(FDataComponentTypes.ICE_LIKE, IceLikeComponent.DEFAULT)
                            .method_57349(FDataComponentTypes.CAPE, CapeComponent.FROSTOLOGY_CLOAK)
                            .method_57349(class_9334.field_54196, FrostologyCloakItemComponents.createEquippableComponent())
                            .method_7894(class_1814.field_8904)
                            .method_7889(1)
            )
    );

    public static final class_1792 ICE_SKATES = register(
            "ice_skates",
            settings -> new class_1792(
                    settings
                            .method_66332(FArmorMaterials.FUR, class_8051.field_41937)
                            .method_7895(class_8051.field_41937.method_56690(5))
                            .method_57349(FDataComponentTypes.FROST_RESISTANCE, FrostResistanceComponent.VERY_PROTECTIVE)
            )
    );

    public static final class_1792 ARMORED_ICE_SKATES = register(
            "armored_ice_skates",
            settings -> new class_1792(
                    settings
                            .method_66332(FArmorMaterials.FUR_LINED_CHAINMAIL, class_8051.field_41937)
                            .method_7895(class_8051.field_41937.method_56690(15))
                            .method_57349(FDataComponentTypes.FROST_RESISTANCE, FrostResistanceComponent.VERY_PROTECTIVE)
            )
    );

    public static final class_1792 POLAR_BEAR_FUR_TUFT = register("polar_bear_fur_tuft");
    public static final class_1792 WOLF_FUR_TUFT = register("wolf_fur_tuft");
    public static final class_1792 OCELOT_FUR_TUFT = register("ocelot_fur_tuft");

    public static final class_1792 ICICLE = register(
            "icicle",
            settings -> new IcicleItem(FBlocks.ICICLE, settings)
    );
    public static final class_1792 COLD_SUN_LICHEN = register("cold_sun_lichen", FBlocks.COLD_SUN_LICHEN);
    public static final class_1792 COOL_SUN_LICHEN = register("cool_sun_lichen", FBlocks.COOL_SUN_LICHEN);
    public static final class_1792 WARM_SUN_LICHEN = register("warm_sun_lichen", FBlocks.WARM_SUN_LICHEN);
    public static final class_1792 HOT_SUN_LICHEN = register("hot_sun_lichen", FBlocks.HOT_SUN_LICHEN);
    public static final class_1792 FROST_WAND = register(
            "frost_wand",
            settings -> new FrostWandItem(
                    settings
                            .method_7889(1)
                            .method_7895(250)
                            .method_57348(FrostWandItem.createAttributeModifiers())
                            .method_57349(class_9334.field_50077, FrostWandItem.createToolComponent())
                            .method_7894(class_1814.field_8903)
                            .method_61647(FItemTags.REPAIRS_FROST_WAND)
                            .method_61649(15)
            )
    );
    public static final class_1792 GLACIAL_ARROW = register(
            "glacial_arrow",
            GlacialArrowItem::new
    );

    public static final class_1792 FROSTOLOGER_SPAWN_EGG = register(
            "frostologer_spawn_egg",
            settings -> new class_1826(settings.method_72499(FEntityTypes.FROSTOLOGER))
    );
    public static final class_1792 CHILLAGER_SPAWN_EGG = register(
            "chillager_spawn_egg",
            settings -> new class_1826(settings.method_72499(FEntityTypes.CHILLAGER))
    );

    public static final class_1792 BITER_SPAWN_EGG = register(
            "biter_spawn_egg",
            settings -> new class_1826(settings.method_72499(FEntityTypes.BITER))
    );

    public static final class_1792 FROZEN_TORCH = register(
            "frozen_torch",
            settings -> new class_1827(
                    FBlocks.FROZEN_TORCH,
                    FBlocks.FROZEN_WALL_TORCH,
                    class_2350.field_11033,
                    settings.method_63685()
            )
    );

    public static final class_1792 PACKED_SNOW = register(
            "packed_snow", FBlocks.PACKED_SNOW
    );
    public static final class_1792 PACKED_SNOWBALL = register(
            "packed_snowball",
            settings -> new PackedSnowBallItem(settings.method_7889(16))
    );
    public static final class_1792 PACKED_SNOW_BLOCK = register(
            "packed_snow_block", FBlocks.PACKED_SNOW_BLOCK
    );
    public static final class_1792 PACKED_SNOW_BRICKS = register(
            "packed_snow_bricks", FBlocks.PACKED_SNOW_BRICKS
    );
    public static final class_1792 PACKED_SNOW_BRICK_STAIRS = register(
            "packed_snow_brick_stairs", FBlocks.PACKED_SNOW_BRICK_STAIRS
    );
    public static final class_1792 PACKED_SNOW_BRICK_SLAB = register(
            "packed_snow_brick_slab", FBlocks.PACKED_SNOW_BRICK_SLAB
    );
    public static final class_1792 PACKED_SNOW_BRICK_WALL = register(
            "packed_snow_brick_wall", FBlocks.PACKED_SNOW_BRICK_WALL
    );

    public static final class_1792 ICE_PANE = register("ice_pane", FBlocks.ICE_PANE);
    public static final class_1792 CUT_PACKED_ICE = register("cut_packed_ice", FBlocks.CUT_PACKED_ICE);
    public static final class_1792 CUT_PACKED_ICE_STAIRS = register("cut_packed_ice_stairs", FBlocks.CUT_PACKED_ICE_STAIRS);
    public static final class_1792 CUT_PACKED_ICE_SLAB = register("cut_packed_ice_slab", FBlocks.CUT_PACKED_ICE_SLAB);
    public static final class_1792 CUT_PACKED_ICE_WALL = register("cut_packed_ice_wall", FBlocks.CUT_PACKED_ICE_WALL);
    public static final class_1792 CUT_BLUE_ICE = register("cut_blue_ice", FBlocks.CUT_BLUE_ICE);
    public static final class_1792 CUT_BLUE_ICE_STAIRS = register("cut_blue_ice_stairs", FBlocks.CUT_BLUE_ICE_STAIRS);
    public static final class_1792 CUT_BLUE_ICE_SLAB = register("cut_blue_ice_slab", FBlocks.CUT_BLUE_ICE_SLAB);
    public static final class_1792 CUT_BLUE_ICE_WALL = register("cut_blue_ice_wall", FBlocks.CUT_BLUE_ICE_WALL);

    public static final class_1792 SNOWFLAKE_BANNER_PATTERN = register(
            "snowflake_banner_pattern",
            settings -> new class_1792(
                    settings
                            .method_7889(1)
                            .method_57349(class_9334.field_56398, FBannerPatternTags.SNOWFLAKE_PATTERN_ITEM)
            )
    );

    public static final class_1792 ICICLE_BANNER_PATTERN = register(
            "icicle_banner_pattern",
            settings -> new class_1792(
                    settings
                            .method_7889(1)
                            .method_7894(class_1814.field_8907)
                            .method_57349(class_9334.field_56398, FBannerPatternTags.ICICLE_PATTERN_ITEM)
            )
    );

    public static final class_1792 FROSTOLOGY_BANNER_PATTERN = register(
            "frostology_banner_pattern",
            settings -> new class_1792(
                    settings
                            .method_7889(1)
                            .method_7894(class_1814.field_8903)
                            .method_57349(class_9334.field_56398, FBannerPatternTags.FROSTOLOGY_PATTERN_ITEM)
            )
    );

    public static final class_1792 ICY_TRIAL_SPAWNER = register("icy_trial_spawner", FBlocks.ICY_TRIAL_SPAWNER);

    public static final class_1792 ICY_VAULT = register("icy_vault", FBlocks.ICY_VAULT);

    public static final class_1792 CASTLE_KEY = register("castle_key");

    public static final class_1792 OMINOUS_CASTLE_KEY = register("ominous_castle_key");

    public static final class_1792 BRITTLE_ICE = register("brittle_ice", FBlocks.BRITTLE_ICE);

    public static final class_1792 FROZEN_ROD = register("frozen_rod");

    public static final class_1792 GLACIAL_ARMOR_TRIM_SMITHING_TEMPLATE = register(
            "glacial_armor_trim_smithing_template",
            settings -> class_8052.method_48418(settings.method_7894(class_1814.field_8904))
    );

    public static final class_1792 SNOW_MAN_ARMOR_TRIM_SMITHING_TEMPLATE = register(
            "snow_man_armor_trim_smithing_template",
            settings -> class_8052.method_48418(settings.method_7894(class_1814.field_8907))
    );

    public static void initialize() {
        Frostiful.LOGGER.debug("Initialized Frostiful items");
        FSmithingTemplateItem.addTemplatesToLoot();
        ResistanceComponentBuilder.initialize();
    }

    private static class_1792 register(String id, class_2248 block) {
        return register(id, settings -> new class_1747(block, settings.method_63685()));
    }

    private static class_1792 register(String id) {
        return register(id, class_1792::new, new class_1792.class_1793());
    }

    private static class_1792 register(String id, Function<class_1792.class_1793, class_1792> itemFactory) {
        return register(id, itemFactory, new class_1792.class_1793());
    }

    private static class_1792 register(String id, Function<class_1792.class_1793, class_1792> itemFactory, class_1792.class_1793 settings) {
        class_5321<class_1792> key = class_5321.method_29179(class_7924.field_41197, Frostiful.id(id));
        class_1792 item = itemFactory.apply(settings.method_63686(key));
        return class_2378.method_39197(class_7923.field_41178, key, item);
    }

    private FItems() {

    }
}
