package com.github.thedeathlycow.frostiful.survival.wind;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.entity.FreezingWindEntity;
import com.github.thedeathlycow.frostiful.entity.WindEntity;
import com.github.thedeathlycow.frostiful.registry.FSoundEvents;
import com.github.thedeathlycow.frostiful.server.network.PointWindSpawnPacket;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_5819;

public class PointWindSpawnStrategy implements WindSpawnStrategy {

    private static final int SIZE = 3;
    private static final int POWER_SCALE = 6;


    @Override
    public boolean spawn(class_1937 world, class_2338 spawnPos, boolean isInAir) {

        if (!(world instanceof class_3218 serverWorld)) {
            return false;
        }
        class_238 box = new class_238(spawnPos).method_1014(SIZE);
        class_243 center = box.method_1005();
        PointWindSpawnPacket.sendToNearbyPlayersFromServer(serverWorld, spawnPos, center);

        for (class_2338 pos : class_2338.method_25996(spawnPos, SIZE / 2, SIZE / 2, SIZE / 2)) {

            WindManager.INSTANCE.extinguishBlock(
                    world.method_8320(pos),
                    world,
                    pos,
                    () -> {
                        serverWorld.method_43128(
                                null,
                                center.field_1352, center.field_1351, center.field_1350,
                                FSoundEvents.ENTITY_FREEZING_WIND_BLOWOUT,
                                class_3419.field_15256,
                                0.75f,
                                0.9f + serverWorld.field_9229.method_43057() / 3
                        );
                    }
            );
        }

        world.method_8390(class_1309.class, box, WindEntity.CAN_BE_BLOWN)
                .forEach(entity -> {
                    WindEntity.pushEntity(entity, world, center, POWER_SCALE);
                    FreezingWindEntity.freezeEntity(
                            entity,
                            Frostiful.getConfig().freezingConfig.getFreezingWindFrost() * POWER_SCALE
                    );
                });

        return true;
    }

    public static class_243 randomParticlePos(class_243 origin, class_5819 random) {
        return new class_243(
                origin.field_1352 + SIZE * (2.0 * random.method_43058() - 1.0),
                origin.field_1351 + SIZE * (2.0 * random.method_43058() - 1.0),
                origin.field_1350 + SIZE * (2.0 * random.method_43058() - 1.0)
        );
    }
}
