/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.frostiful.client;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.config.FrostifulConfig;
import com.github.thedeathlycow.thermoo.api.client.HeartBarContext;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2i;

@Environment(value=EnvType.CLIENT)
public class FrozenHeartsOverlay {
    public static final class_2960 HEART_OVERLAY_TEXTURE = Frostiful.id("textures/gui/cold_heart_overlay.png");
    private static final int TEXTURE_WIDTH = 18;
    private static final int TEXTURE_HEIGHT = 10;

    public static void afterHealthBar(class_332 context, class_1657 player, HeartBarContext heartBarContext) {
        FrostifulConfig config = Frostiful.getConfig();
        if (!config.clientConfig.doColdHeartOverlay() || player.thermoo$isWarm()) {
            return;
        }
        int coldHalfHearts = FrozenHeartsOverlay.getColdHalfHearts((class_1309)player, heartBarContext.positions().size());
        int coldHearts = FrozenHeartsOverlay.getColdHeartsFromHalfHearts(coldHalfHearts);
        boolean drawHalfHeartAtEnd = coldHalfHearts % 2 != 0;
        int heartsRendered = 0;
        for (Vector2i pos : heartBarContext.positions()) {
            if (heartsRendered >= coldHearts) break;
            boolean isHalfHeart = drawHalfHeartAtEnd && heartsRendered == coldHearts - 1;
            int u = isHalfHeart ? 9 : 0;
            context.method_25290(class_10799.field_56883, HEART_OVERLAY_TEXTURE, pos.x, pos.y, (float)u, 0.0f, 9, 10, 18, 10);
        }
    }

    public static void afterMountHealthBar(class_332 context, class_1657 player, class_1309 mount, HeartBarContext heartBarContext) {
        FrostifulConfig config = Frostiful.getConfig();
        if (!config.clientConfig.doColdHeartOverlay() || mount.thermoo$isWarm()) {
            return;
        }
        int coldHalfHearts = FrozenHeartsOverlay.getColdHalfHearts(mount, heartBarContext.positions().size());
        int coldHearts = FrozenHeartsOverlay.getColdHeartsFromHalfHearts(coldHalfHearts);
        boolean drawHalfHeartAtEnd = coldHalfHearts % 2 != 0;
        int heartsRendered = 0;
        for (Vector2i pos : heartBarContext.positions()) {
            boolean isHalfHeart;
            if (heartsRendered >= coldHearts) break;
            boolean bl = isHalfHeart = drawHalfHeartAtEnd && heartsRendered == coldHearts - 1;
            if (isHalfHeart) {
                context.method_25290(class_10799.field_56883, HEART_OVERLAY_TEXTURE, pos.x() + 4, pos.y(), 4.0f, 0.0f, 5, 10, 18, 10);
            } else {
                context.method_25290(class_10799.field_56883, HEART_OVERLAY_TEXTURE, pos.x(), pos.y(), 0.0f, 0.0f, 9, 10, 18, 10);
            }
            ++heartsRendered;
        }
    }

    private static int getColdHalfHearts(@NotNull class_1309 entity, int maxDisplayHealth) {
        float freezingProgress = -entity.thermoo$getTemperatureScale();
        return Math.round(freezingProgress * (float)maxDisplayHealth);
    }

    private static int getColdHeartsFromHalfHearts(int frozenHealthPoints) {
        return class_3532.method_15386((float)((float)frozenHealthPoints / 2.0f));
    }

    private FrozenHeartsOverlay() {
    }
}

